/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.collections.transformation.FilteredList;
import net.raumzeitfalle.fx.filechooser.FileUpdateService;
import net.raumzeitfalle.fx.filechooser.IndexedPath;
import net.raumzeitfalle.fx.filechooser.PathFilter;
import net.raumzeitfalle.fx.filechooser.UpdateService;
import net.raumzeitfalle.fx.filechooser.locations.Location;

final class FileChooserModel {
    private final ObservableList<IndexedPath> allPaths;
    private final FilteredList<IndexedPath> filteredPaths;
    private final UpdateService fileUpdateService;
    private final ListProperty<IndexedPath> allPathsProperty;
    private final ListProperty<IndexedPath> filteredPathsProperty;
    private final ObjectProperty<Path> fileSelection = new SimpleObjectProperty();
    private final StringProperty selectedFileName = new SimpleStringProperty("");
    private final BooleanProperty invalidSelection = new SimpleBooleanProperty(true);
    private final ObservableList<PathFilter> observablePathFilter = FXCollections.observableArrayList(new ArrayList(30));
    private final ObservableSet<Location> locations = FXCollections.observableSet(new LinkedHashSet());
    private PathFilter effectiveFilter = PathFilter.acceptAllFiles("all files");
    private final ObjectProperty<Path> pastedPath = new SimpleObjectProperty();

    public static FileChooserModel startingInUsersHome(PathFilter ... filter) {
        return FileChooserModel.startingIn(FileChooserModel.getUsersHome(), filter);
    }

    public static FileChooserModel startingIn(Path startFolder, PathFilter ... filter) {
        ObservableList paths = FXCollections.observableArrayList(new ArrayList(300000));
        Supplier<UpdateService> serviceProvider = () -> new FileUpdateService(startFolder, (ObservableList<IndexedPath>)paths);
        FileChooserModel model = new FileChooserModel((ObservableList<IndexedPath>)paths, serviceProvider);
        model.observablePathFilter.addAll((Object[])filter);
        return model;
    }

    public FileChooserModel(ObservableList<IndexedPath> paths, Supplier<UpdateService> serviceProvider) {
        this.allPaths = paths;
        this.filteredPaths = new FilteredList(this.allPaths);
        this.allPathsProperty = new SimpleListProperty(this.allPaths);
        this.filteredPathsProperty = new SimpleListProperty(this.filteredPaths);
        this.fileUpdateService = serviceProvider.get();
        this.fileUpdateService.startUpdate();
        this.selectedFileName.bind((ObservableValue)this.createStringBindingTo((ObservableValue<?>)this.fileSelection));
        this.initializeFilter("");
    }

    private StringBinding createStringBindingTo(ObservableValue<?> observable) {
        Callable<String> callable = () -> null != observable.getValue() ? String.valueOf(observable.getValue()) : "";
        return Bindings.createStringBinding(callable, (Observable[])new Observable[]{observable});
    }

    private static Path getUsersHome() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    public UpdateService getUpdateService() {
        return this.fileUpdateService;
    }

    public ObjectProperty<Path> currentSearchPath() {
        return this.fileUpdateService.searchPathProperty();
    }

    public ObservableList<IndexedPath> getFilteredPaths() {
        return this.filteredPaths;
    }

    ReadOnlyIntegerProperty filteredPathsSizeProperty() {
        return this.filteredPathsProperty.sizeProperty();
    }

    ReadOnlyIntegerProperty allPathsSizeProperty() {
        return this.allPathsProperty.sizeProperty();
    }

    ReadOnlyBooleanProperty invalidSelectionProperty() {
        return this.invalidSelection;
    }

    public void setSelectedFile(IndexedPath file) {
        if (null == file) {
            this.fileSelection.setValue(null);
        } else {
            Path rootDir = (Path)this.fileUpdateService.searchPathProperty().get();
            this.fileSelection.setValue((Object)file.asPath(rootDir).toAbsolutePath().normalize());
        }
        this.invalidSelection.setValue(Boolean.valueOf(null == file));
    }

    public Path getSelectedFile() {
        return (Path)this.fileSelection.getValue();
    }

    public ReadOnlyObjectProperty<Path> selectedFileProperty() {
        return this.fileSelection;
    }

    public ReadOnlyStringProperty selectedFileNameProperty() {
        return this.selectedFileName;
    }

    public void updateFilterCriterion(String criterion) {
        Predicate<IndexedPath> combined = this.createManualListFilter(criterion).and(indexedPath -> this.effectiveFilter.getPredicate().test(indexedPath.toString()));
        this.filteredPaths.setPredicate(combined);
    }

    public void updateFilterCriterion(PathFilter pathFilter, String criterion) {
        this.effectiveFilter = pathFilter;
        this.updateFilterCriterion(criterion);
    }

    private Predicate<IndexedPath> createManualListFilter(String criterion) {
        String trimmed = criterion.trim();
        String withAsterisks = this.removeInvalidCharsExceptAsterisk(trimmed);
        String corrected = withAsterisks.replace("*", "");
        int firstAsterisk = withAsterisks.indexOf(42);
        int lastAsterisk = withAsterisks.lastIndexOf(42);
        if (withAsterisks.endsWith("*") && !withAsterisks.startsWith("*")) {
            if (corrected.length() > 0) {
                return p -> null == corrected || corrected.isEmpty() || p.toString().toLowerCase().startsWith(corrected.toLowerCase());
            }
        } else if (withAsterisks.startsWith("*") && !withAsterisks.endsWith("*")) {
            if (corrected.length() > 0) {
                return p -> null == corrected || corrected.isEmpty() || p.toString().toLowerCase().endsWith(corrected.toLowerCase());
            }
        } else if (firstAsterisk > 0 && lastAsterisk > 0 && firstAsterisk == lastAsterisk && withAsterisks.length() >= 3) {
            String left = withAsterisks.substring(0, firstAsterisk);
            String right = withAsterisks.substring(lastAsterisk + 1);
            return p -> null == corrected || corrected.isEmpty() || p.toString().toLowerCase().startsWith(left) && p.toString().toLowerCase().endsWith(right);
        }
        return p -> null == corrected || corrected.isEmpty() || p.toString().toLowerCase().contains(corrected.toLowerCase());
    }

    public void initializeFilter(String text) {
        if (!this.observablePathFilter.isEmpty()) {
            PathFilter combined = (PathFilter)this.observablePathFilter.get(0);
            for (PathFilter filter : this.observablePathFilter) {
                combined = combined.combine(filter);
            }
            this.effectiveFilter = combined;
        }
        this.updateFilterCriterion(text);
    }

    private String removeInvalidCharsExceptAsterisk(String criterion) {
        char[] invalidChars = new char[]{'\"', '?', '<', '>', '|', ':'};
        String corrected = criterion;
        for (char invalid : invalidChars) {
            corrected = corrected.replace(String.valueOf(invalid), "");
        }
        return this.removeDoubles(corrected, "*");
    }

    private String removeDoubles(String text, String single) {
        String dbl = single + single;
        String corrected = text;
        while (corrected.contains(dbl)) {
            corrected = corrected.replace(dbl, single);
        }
        return corrected;
    }

    public void refreshFiles() {
        this.fileUpdateService.refresh();
    }

    public void updateFilesIn(File directory) {
        if (null != directory) {
            this.fileUpdateService.restartIn(directory.toPath());
        }
    }

    public void updateFilesIn(Location location) {
        if (null != location) {
            this.fileUpdateService.restartIn(location.getPath());
        }
    }

    public void changeToUsersHome() {
        this.fileUpdateService.restartIn(FileChooserModel.getUsersHome());
    }

    public ObservableList<PathFilter> getPathFilter() {
        return this.observablePathFilter;
    }

    public void addLocation(Location location) {
        this.locations.add((Object)location);
    }

    public ObservableSet<Location> getLocations() {
        return this.locations;
    }

    public void sort(Comparator<IndexedPath> comparator) {
        this.allPaths.sort(comparator);
    }

    public void addOrRemoveFilter(PathFilter newFilter) {
        boolean wasRemoved = this.observablePathFilter.removeIf(pf -> pf.getName().equalsIgnoreCase(newFilter.getName()));
        if (!wasRemoved) {
            this.observablePathFilter.add((Object)newFilter);
        }
    }

    public Path getPastedPath() {
        return (Path)this.pastedPath.get();
    }

    public ObjectProperty<Path> pastedPathProperty() {
        return this.pastedPath;
    }
}

