/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.raumzeitfalle.fx.filechooser.DirectoryChooserOption;
import net.raumzeitfalle.fx.filechooser.FileChooser;
import net.raumzeitfalle.fx.filechooser.FileChooserModel;
import net.raumzeitfalle.fx.filechooser.FileChooserViewOption;
import net.raumzeitfalle.fx.filechooser.HideableView;
import net.raumzeitfalle.fx.filechooser.PathFilter;
import net.raumzeitfalle.fx.filechooser.Skin;
import net.raumzeitfalle.fx.filechooser.locations.Location;

public class FXFileChooserStage
extends Stage
implements HideableView {
    private final FileChooserModel model;

    public static FXFileChooserStage create(Skin skin, PathFilter ... filters) {
        PathFilter[] filter2use = filters;
        if (filters.length == 0) {
            filter2use = new PathFilter[]{PathFilter.acceptAllFiles()};
        }
        Skin skinToUse = skin == null ? Skin.MODENA : skin;
        return FXFileChooserStage.create(skinToUse, Paths.get(".", new String[0]), filter2use);
    }

    public static FXFileChooserStage create(Skin skin, DirectoryChooserOption dirChooserOption, PathFilter ... filters) {
        PathFilter[] filter2use = filters;
        if (filters.length == 0) {
            filter2use = new PathFilter[]{PathFilter.acceptAllFiles()};
        }
        Skin skinToUse = skin == null ? Skin.MODENA : skin;
        return FXFileChooserStage.create(skinToUse, Paths.get(".", new String[0]), dirChooserOption, filter2use);
    }

    public static FXFileChooserStage create(Skin skin, Path startsIn, PathFilter ... filters) {
        PathFilter[] filter2use = filters;
        if (filters.length == 0) {
            filter2use = new PathFilter[]{PathFilter.acceptAllFiles()};
        }
        Skin skinToUse = skin == null ? Skin.MODENA : skin;
        Path location = startsIn == null ? Paths.get(".", new String[0]) : startsIn;
        return new FXFileChooserStage(FileChooserModel.startingIn(location, filter2use), skinToUse);
    }

    public static FXFileChooserStage create(Skin skin, Path startsIn, DirectoryChooserOption dirChooserOption, PathFilter ... filters) {
        PathFilter[] filter2use = filters;
        if (filters.length == 0) {
            filter2use = new PathFilter[]{PathFilter.acceptAllFiles()};
        }
        Skin skinToUse = skin == null ? Skin.MODENA : skin;
        Path location = startsIn == null ? Paths.get(".", new String[0]) : startsIn;
        return new FXFileChooserStage(FileChooserModel.startingIn(location, filter2use), skinToUse, dirChooserOption);
    }

    private FXFileChooserStage(FileChooserModel model, Skin skin) {
        this(model, skin, DirectoryChooserOption.JAVAFX_PLATFORM);
    }

    FXFileChooserStage(FileChooserModel model, Skin skin, DirectoryChooserOption dirChooserOption) {
        this.model = Objects.requireNonNull(model);
        FileChooser view = new FileChooser(this.model, skin, dirChooserOption, FileChooserViewOption.STAGE, this);
        Scene scene = new Scene((Parent)view);
        this.setScene(scene);
        StringBinding sb = Bindings.createStringBinding(() -> {
            Path current = (Path)model.currentSearchPath().get();
            if (current != null) {
                String path = current.normalize().toAbsolutePath().toString();
                if (path.length() > 100) {
                    return path.substring(0, 20) + " ... " + path.substring(path.length() - 75, path.length());
                }
                return path;
            }
            return "";
        }, (Observable[])new Observable[]{model.currentSearchPath()});
        this.titleProperty().bind((ObservableValue)sb);
        this.initModality(Modality.APPLICATION_MODAL);
    }

    public Optional<Path> showOpenDialog(Window ownerWindow) {
        if (null == this.getOwner()) {
            this.initOwner(ownerWindow);
        }
        this.showAndWait();
        return this.getSelectedPath();
    }

    private Optional<Path> getSelectedPath() {
        return Optional.ofNullable(this.model.getSelectedFile());
    }

    @Override
    public void closeView() {
        this.hide();
    }

    public void addLocations(List<Location> locations) {
        locations.forEach(this.model::addLocation);
    }

    FileChooserModel getModel() {
        return this.model;
    }
}

