/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.raumzeitfalle.fx.filechooser.FXDirectoryChooser;
import net.raumzeitfalle.fx.filechooser.FileChooser;
import net.raumzeitfalle.fx.filechooser.FileChooserModel;
import net.raumzeitfalle.fx.filechooser.FileChooserViewOption;
import net.raumzeitfalle.fx.filechooser.HideableView;
import net.raumzeitfalle.fx.filechooser.PathFilter;
import net.raumzeitfalle.fx.filechooser.Skin;
import net.raumzeitfalle.fx.filechooser.locations.Location;

public class FXFileChooserDialog
extends Dialog<Path>
implements HideableView {
    private final FileChooserModel model;
    private static final double MIN_WIDTH = 700.0;
    private static final double MIN_HEIGHT = 550.0;

    public static FXFileChooserDialog create(Skin skin, PathFilter ... filter) {
        FileChooserModel model = FileChooserModel.startingInUsersHome(filter);
        return new FXFileChooserDialog(skin, model);
    }

    public void addFilter(PathFilter filter) {
        this.model.addOrRemoveFilter(filter);
    }

    static FXFileChooserDialog create(Skin skin, FileChooserModel model) {
        return new FXFileChooserDialog(skin, model);
    }

    private FXFileChooserDialog(Skin skin, FileChooserModel fileChooserModel) {
        this.model = fileChooserModel;
        Skin.applyToDialog(this, skin);
        this.setTitle("File Selection");
        this.setHeaderText("Select File from for processing:");
        StringBinding sb = Bindings.createStringBinding(() -> {
            Path current = (Path)this.model.currentSearchPath().get();
            if (current != null) {
                return current.normalize().toAbsolutePath().toString();
            }
            return "";
        }, (Observable[])new Observable[]{this.model.currentSearchPath()});
        this.headerTextProperty().bind((ObservableValue)sb);
        this.initModality(Modality.APPLICATION_MODAL);
        Supplier<Window> ownerProvider = () -> this.getDialogPane().getScene().getWindow();
        FXDirectoryChooser pathSupplier = FXDirectoryChooser.createIn(this.model.currentSearchPath(), ownerProvider);
        FileChooser view = new FileChooser(pathSupplier, null, this.model, skin, FileChooserViewOption.DIALOG, this);
        this.getDialogPane().setContent((Node)view);
        ButtonType okay = ButtonType.OK;
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okay, ButtonType.CANCEL});
        Node okayButton = this.getDialogPane().lookupButton(okay);
        okayButton.disableProperty().bind((ObservableValue)this.model.invalidSelectionProperty());
        this.setResultConverter(dialogButton -> {
            if (dialogButton == okay) {
                this.hide();
                return this.model.getSelectedFile();
            }
            return null;
        });
        this.resizableProperty().set(true);
        this.setOnShowing(this::configureMinWindowSize);
    }

    private void configureMinWindowSize(Event evt) {
        Platform.runLater(this::setMinWinSize);
    }

    private void setMinWinSize() {
        Window window = this.getDialogPane().getScene().getWindow();
        Stage stage = (Stage)window;
        stage.setMinHeight(550.0);
        stage.setMinWidth(700.0);
    }

    public Optional<Path> showOpenDialog(Window ownerWindow) {
        if (null == this.getOwner()) {
            this.initOwner(ownerWindow);
        }
        return this.showAndWait();
    }

    @Override
    public void closeView() {
        this.getDialogPane().getScene().getWindow().hide();
    }

    public void addLocations(List<Location> locations) {
        locations.forEach(this.model::addLocation);
    }
}

