/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import net.raumzeitfalle.fx.filechooser.PathUpdateHandler;

public class FXDirectoryChooser
implements PathUpdateHandler {
    private final DirectoryChooser dc = new DirectoryChooser();
    private final Supplier<Window> ownerProvider;

    public static FXDirectoryChooser createIn(ObjectProperty<Path> startLocation, Supplier<Window> ownerProvider) {
        Objects.requireNonNull(startLocation, "startLocation must not be null");
        Path location = (Path)startLocation.get();
        if (null == location) {
            location = Paths.get("./", new String[0]);
        }
        return new FXDirectoryChooser(location, ownerProvider);
    }

    public static FXDirectoryChooser createIn(Path startLocation, Supplier<Window> ownerProvider) {
        Objects.requireNonNull(ownerProvider, "ownerProvider must not be null");
        Objects.requireNonNull(startLocation, "startLocation for file search must not be null.");
        Path location = startLocation;
        if (String.valueOf(startLocation).equals("")) {
            location = Paths.get("./", new String[0]);
        }
        return new FXDirectoryChooser(location, ownerProvider);
    }

    private FXDirectoryChooser(Path startLocation, Supplier<Window> ownerProvider) {
        this.dc.setInitialDirectory(startLocation.toFile());
        this.ownerProvider = Objects.requireNonNull(ownerProvider, "ownerProvider must not be null");
    }

    @Override
    public void getUpdate(Consumer<Path> update) {
        Platform.runLater(() -> Optional.ofNullable(this.dc.showDialog(this.ownerProvider.get())).map(File::toPath).ifPresent(update.andThen(this::changeDir)));
    }

    private void changeDir(Path newLocation) {
        this.dc.setInitialDirectory(newLocation.toFile());
    }
}

