/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.dirchooser;

import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import net.raumzeitfalle.fx.dirchooser.DirectoryChooserProperties;

enum DirectoryIcons {
    OPEN("icons/folder-open-32.png"),
    CLOSED("icons/folder-closed-32.png"),
    OPEN_WITH_FILE("icons/folder-file-open-32.png"),
    CLOSED_PLUS("icons/folder-closed-plus-32.png"),
    CLOSED_XL("icons/folder-closed-xl-32.png"),
    HOST("icons/host-computer-32.png"),
    EMPTY("icons/folder-empty-32.png"),
    NO_SUBDIRS_XL("icons/folder-closed-unknown-xl-32.png"),
    DRIVE("icons/windows-drive-32.png"),
    DRIVE_PLUS("icons/windows-drive-plus-32.png"),
    DRIVE_XL("icons/windows-drive-xl-32.png"),
    DRIVE_EMPTY("icons/windows-drive-empty-32.png");

    private final String iconResource;

    private DirectoryIcons(String iconFileName) {
        this.iconResource = DirectoryIcons.class.getResource(iconFileName).toExternalForm();
    }

    ImageView create() {
        ImageView image = new ImageView(this.iconResource);
        image.preserveRatioProperty().set(true);
        image.setFitHeight((double)DirectoryChooserProperties.getIconSize());
        image.getStyleClass().add((Object)"directory-icon");
        return image;
    }

    protected StackPane get() {
        StackPane pane = new StackPane();
        pane.getChildren().add((Object)this.create());
        pane.setMinWidth(DirectoryChooserProperties.getIconPaneSize());
        pane.getStyleClass().add((Object)"directory-icon-pane");
        return pane;
    }
}

