/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.dirchooser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javax.swing.filechooser.FileSystemView;
import net.raumzeitfalle.fx.dirchooser.DirectoryIcons;
import net.raumzeitfalle.fx.dirchooser.DirectoryTreeItem;
import net.raumzeitfalle.fx.dirchooser.DirectoryTreeUpdateTask;

public class DirectoryChooserController
implements Initializable {
    @FXML
    private TextField selectedDirectory;
    @FXML
    private TreeView<String> directoryTree;
    @FXML
    private Button chooseFiles;
    @FXML
    private Button okButton;
    @FXML
    private Button cancelButton;
    @FXML
    private TextField goToTextField;
    private ObjectProperty<Path> selectedDirectoryProperty = new SimpleObjectProperty(null);
    private DirectoryTreeItem root;
    private DirectoryTreeItem localRoot;
    private DirectoryTreeItem networkRoot;
    private Runnable onSelect;
    private Runnable onCancel;
    private Map<Path, Task<Void>> runningUpdateTasks = new ConcurrentHashMap<Path, Task<Void>>();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private boolean dontExpandOnSelect;

    public void initialize(URL location, ResourceBundle resources) {
        this.registerShutdownHook();
        this.prepareTree();
        this.configureSelectedDirBinding();
        this.okButton.disableProperty().bind((ObservableValue)this.selectedDirectoryProperty.isNull());
        this.okButton.setOnAction(e -> this.okayAction());
        this.cancelButton.setOnAction(e -> this.cancelAction());
        this.configureGotoAction();
        this.configureOkayAction();
        this.configureEscapeActions();
        this.configureTreeNavigationKeys();
        this.configureClickHandling();
        this.configureSelectionHandling();
        this.initDirTree();
    }

    private void prepareTree() {
        String hostName = this.getHostName();
        this.root = new DirectoryTreeItem("root");
        this.localRoot = new DirectoryTreeItem(hostName);
        this.localRoot.setGraphic((Node)DirectoryIcons.HOST.get());
        this.networkRoot = new DirectoryTreeItem("Network");
        this.networkRoot.setGraphic((Node)DirectoryIcons.HOST.get());
        this.root.getChildren().add((Object)this.localRoot);
        this.directoryTree.setRoot((TreeItem)this.root);
        this.directoryTree.showRootProperty().set(false);
        this.localRoot.setExpanded(true);
        this.networkRoot.setExpanded(false);
    }

    private void configureSelectionHandling() {
        this.directoryTree.getSelectionModel().selectedItemProperty().addListener((observable, oldItem, newItem) -> {
            if (null == newItem) {
                this.selectedDirectoryProperty.set(null);
            }
            if (null != newItem && null == ((DirectoryTreeItem)((Object)newItem)).getFullPath()) {
                this.selectedDirectoryProperty.set(null);
            }
            if (null != newItem && null != ((DirectoryTreeItem)((Object)newItem)).getFullPath()) {
                DirectoryTreeItem item = (DirectoryTreeItem)((Object)newItem);
                if (null == item.getFullPath()) {
                    this.selectedDirectoryProperty.set(null);
                } else {
                    this.selectedDirectoryProperty.set((Object)Paths.get(item.getFullPath(), new String[0]));
                }
                if (!this.dontExpandOnSelect) {
                    this.readSubDirsForSelectedItem();
                }
                this.goToTextField.textProperty().setValue(item.getFullPath());
            }
        });
    }

    private void configureClickHandling() {
        this.directoryTree.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getClickCount() == 2) {
                mouseEvent.consume();
                this.readSubDirsForSelectedItem();
            }
        });
    }

    private void configureTreeNavigationKeys() {
        this.directoryTree.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.RIGHT) {
                keyEvent.consume();
                this.readSubDirsForSelectedItem();
                this.expandSelectedItem();
            } else if (keyEvent.getCode() == KeyCode.ENTER) {
                this.okayAction();
                keyEvent.consume();
            } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                this.cancelAction();
                keyEvent.consume();
            }
        });
    }

    private void configureEscapeActions() {
        this.okButton.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE) {
                this.cancelAction();
                keyEvent.consume();
            }
        });
        this.cancelButton.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE) {
                this.cancelAction();
                keyEvent.consume();
            }
        });
        this.selectedDirectory.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE) {
                this.cancelAction();
                keyEvent.consume();
            }
        });
    }

    private void configureOkayAction() {
        this.chooseFiles.setOnAction(e -> {
            if (this.okButton.isDisable()) {
                this.cancelAction();
            } else {
                this.okayAction();
            }
        });
    }

    private void configureGotoAction() {
        this.goToTextField.setOnAction(this::handleGotoAction);
        this.goToTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.handleGotoAction(null);
                keyEvent.consume();
            }
        });
    }

    private void configureSelectedDirBinding() {
        StringBinding sb = Bindings.createStringBinding(() -> {
            Path selection = (Path)this.selectedDirectoryProperty.get();
            return selection == null ? "" : selection.toAbsolutePath().toString();
        }, (Observable[])new Observable[]{this.selectedDirectoryProperty});
        this.selectedDirectory.textProperty().bind((ObservableValue)sb);
        this.selectedDirectoryProperty.set(null);
    }

    private void expandSelectedItem() {
        this.expandItem((TreeItem)this.directoryTree.getSelectionModel().selectedItemProperty().get());
    }

    private void readSubDirsForSelectedItem() {
        DirectoryTreeItem item = (DirectoryTreeItem)((Object)this.directoryTree.getSelectionModel().selectedItemProperty().get());
        if (null != item && item.isHuge()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Huge directory");
            alert.setHeaderText("Scanning for subdirs may take a while!");
            alert.setContentText(String.format("This directory holds %s items.", Integer.toString(item.size())));
            Optional userResponse = alert.showAndWait();
            if (userResponse.isPresent() && userResponse.get() == ButtonType.CANCEL) {
                return;
            }
        }
        if (null != item && null != item.getFullPath()) {
            Path path = Paths.get(item.getFullPath(), new String[0]);
            if (item.getChildren().isEmpty()) {
                Task<Void> update = this.runningUpdateTasks.get(path);
                if (null == update) {
                    update = this.createUpdateTask(path, item);
                }
                this.startUpdate(path, update);
            }
        }
    }

    private void startUpdate(Path path, Task<Void> update) {
        this.runningUpdateTasks.put(path, update);
        this.executor.submit((Runnable)update);
    }

    private Task<Void> createUpdateTask(Path path, DirectoryTreeItem item) {
        return new DirectoryTreeUpdateTask(path, item, this.runningUpdateTasks::remove);
    }

    private void expandItem(TreeItem<?> item) {
        if (null != item) {
            item.setExpanded(true);
        }
    }

    private void cancelAction() {
        Platform.runLater((Runnable)this.onCancel);
    }

    private void okayAction() {
        Platform.runLater((Runnable)this.onSelect);
    }

    public void initDirTree() {
        Task<Void> init = new Task<Void>(){

            protected Void call() throws Exception {
                Iterable<Path> rootDirectories = FileSystems.getDefault().getRootDirectories();
                for (Path path : rootDirectories) {
                    DirectoryTreeItem dirItem = new DirectoryTreeItem(path);
                    DirectoryChooserController.this.localRoot.getChildren().add((Object)dirItem);
                }
                return null;
            }
        };
        this.executor.submit((Runnable)init);
    }

    private String getHostName() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            return localhost.getHostName();
        }
        catch (UnknownHostException localhost) {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec("hostname");
                InputStreamReader in = new InputStreamReader(process.getInputStream());
                BufferedReader reader = new BufferedReader(in);
                return reader.readLine();
            }
            catch (IOException e) {
                return "Computer";
            }
        }
    }

    public ReadOnlyObjectProperty<Path> selectedDirectoryProperty() {
        return this.selectedDirectoryProperty;
    }

    public void setOnSelect(Runnable action) {
        this.onSelect = action;
    }

    public void setOnCancel(Runnable action) {
        this.onCancel = action;
    }

    void shutdown() {
        Logger.getLogger(DirectoryChooserController.class.getName()).log(Level.INFO, "shutting down tasks and executors");
        this.executor.shutdownNow();
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    private void handleGotoAction(ActionEvent event) {
        File possibleLocation = this.getPathFromText();
        if (possibleLocation.exists()) {
            Path location = possibleLocation.toPath();
            DirectoryTreeItem share = new DirectoryTreeItem(location);
            share.setGraphic((Node)DirectoryIcons.HOST.get());
            this.updateSharesIfNeeded(share);
            this.scrollToItem(share);
        }
    }

    private void scrollToItem(DirectoryTreeItem share) {
        int index = this.directoryTree.getRow((TreeItem)share);
        this.directoryTree.scrollTo(index);
        Platform.runLater(() -> {
            int i = this.directoryTree.getRow((TreeItem)share);
            this.directoryTree.scrollTo(i);
        });
    }

    private void updateSharesIfNeeded(DirectoryTreeItem share) {
        ObservableList knownShares = this.networkRoot.getChildren();
        Optional<DirectoryTreeItem> optionalShare = knownShares.stream().filter(h -> ((String)h.getValue()).equalsIgnoreCase(share.getFullPath())).map(DirectoryTreeItem.class::cast).findAny();
        if (!optionalShare.isPresent()) {
            Path path = Paths.get(share.getFullPath(), new String[0]);
            File file = path.getRoot().toFile();
            FileSystemView fsView = FileSystemView.getFileSystemView();
            boolean isFsRoot = fsView.isFileSystemRoot(file);
            if (!isFsRoot) {
                Platform.runLater(() -> {
                    if (!this.root.getChildren().contains((Object)this.networkRoot)) {
                        this.root.getChildren().add((Object)this.networkRoot);
                    }
                    this.localRoot.setExpanded(false);
                    this.networkRoot.getChildren().add((Object)share);
                    this.networkRoot.setExpanded(true);
                });
            } else {
                this.expandTreeFor(path);
            }
        }
    }

    private void expandTreeFor(Path path) {
        Logger.getLogger(this.getClass().getName()).log(Level.FINER, "Expanding for {0}", path);
        this.collapseAll();
        Platform.runLater(() -> {
            this.localRoot.setExpanded(false);
            this.networkRoot.setExpanded(false);
            this.root.setExpanded(false);
            DirectoryTreeItem item = this.expandAll(path, 0, this.localRoot);
            if (item != null) {
                Platform.runLater(() -> {
                    this.selectButNotExpand(item);
                    this.scrollToItem(item);
                });
            }
        });
    }

    private void selectButNotExpand(DirectoryTreeItem item) {
        this.dontExpandOnSelect = true;
        this.directoryTree.getSelectionModel().select((Object)item);
        this.dontExpandOnSelect = false;
    }

    private void collapseAll() {
        this.collapse(this.root);
    }

    private void collapse(TreeItem<String> treeItem) {
        for (TreeItem d : treeItem.getChildren()) {
            if (!d.isExpanded()) continue;
            d.setExpanded(false);
            this.collapse((TreeItem<String>)d);
        }
    }

    private DirectoryTreeItem expandAll(Path path, int depth, DirectoryTreeItem treeItem) {
        Path full = this.resolvePath(path, depth);
        for (TreeItem d : treeItem.getChildren()) {
            DirectoryTreeItem child = (DirectoryTreeItem)d;
            Path other = Paths.get(child.getFullPath(), new String[0]);
            if (!full.equals(other)) continue;
            child.setExpanded(true);
            if (depth < path.getNameCount()) {
                return this.expandAll(path, depth + 1, child);
            }
            return child;
        }
        return null;
    }

    private Path resolvePath(Path path, int depth) {
        if (depth == 0) {
            return path.getRoot();
        }
        return path.getRoot().resolve(path.subpath(0, depth));
    }

    private File getPathFromText() {
        Object value = this.goToTextField.getText().replace("\"", "");
        if (((String)value).length() == 2 && ((String)value).charAt(1) == ':') {
            value = (String)value + "\\";
        }
        return new File((String)value);
    }

    public void hideChooseFilesButton() {
        this.setUseChooseFilesButton(false);
    }

    public void showChooseFilesButton() {
        this.setUseChooseFilesButton(true);
    }

    public void setUseChooseFilesButton(boolean toggle) {
        this.chooseFiles.setManaged(toggle);
        this.chooseFiles.setVisible(toggle);
    }

    public void hideCancelButton() {
        this.setUseCancelButton(false);
    }

    public void showCancelButton() {
        this.setUseCancelButton(true);
    }

    public void setUseCancelButton(boolean toggle) {
        this.cancelButton.setManaged(toggle);
        this.cancelButton.setVisible(toggle);
    }
}

