/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.net.URL;
import javafx.scene.Parent;
import javafx.scene.control.Dialog;

public enum Skin {
    MODENA,
    DARK;


    public static <T extends Parent> void applyTo(T parent, Skin skin) {
        String css = skin.getCssLocation(parent);
        if (null != css) {
            parent.getStylesheets().add((Object)css);
            parent.applyCss();
        }
    }

    public static <T extends Dialog<?>> void applyToDialog(T dialog, Skin skin) {
        String css = skin.getCssLocation(dialog);
        if (null != css) {
            dialog.getDialogPane().getStylesheets().add((Object)css);
        }
    }

    private String getStyleName() {
        String cssName = this.name().substring(1).toLowerCase();
        String first = new String(new char[]{this.name().charAt(0)});
        return first + cssName;
    }

    private static String getClassName(Object parent) {
        return parent.getClass().getSimpleName();
    }

    private String getCssLocation(Object parent) {
        String className = Skin.getClassName(parent);
        String styleName = this.getStyleName();
        String styleSheetName = className + styleName + ".css";
        URL url = parent.getClass().getResource(styleSheetName);
        if (url == null) {
            return null;
        }
        return url.toExternalForm();
    }
}

