/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.io.File;
import java.util.function.Predicate;

public interface PathFilter {
    public String getName();

    public Predicate<String> getPredicate();

    default public boolean matches(String pathName) {
        return this.getPredicate().test(pathName);
    }

    default public boolean matches(File file) {
        return this.matches(file.toString());
    }

    default public PathFilter combine(PathFilter other) {
        String label = this.getName() + ", " + other.getName();
        Predicate<String> thisOne = this.getPredicate();
        return PathFilter.create(label, thisOne.or(other.getPredicate()));
    }

    public static PathFilter acceptAllFiles() {
        return PathFilter.acceptAllFiles("*.*");
    }

    public static PathFilter acceptAllFiles(String name) {
        return PathFilter.create(name, p -> true);
    }

    public static PathFilter create(Predicate<String> p) {
        return PathFilter.create(String.valueOf(p), p);
    }

    public static PathFilter create(final String label, final Predicate<String> p) {
        return new PathFilter(){

            @Override
            public Predicate<String> getPredicate() {
                return p;
            }

            @Override
            public String getName() {
                return label;
            }
        };
    }

    public static PathFilter forFileExtension(String extension) {
        return PathFilter.forFileExtension("*." + extension, extension);
    }

    public static PathFilter forFileExtension(String label, String extension) {
        return PathFilter.create(label, p -> {
            String name;
            int lastDot;
            if (null != p && (lastDot = (name = p.toLowerCase()).lastIndexOf(46)) > 0) {
                return name.substring(lastDot).matches("[.]" + extension + "$");
            }
            return false;
        });
    }
}

