/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import net.raumzeitfalle.fx.filechooser.FileChooserProperties;
import net.raumzeitfalle.fx.filechooser.IndexedPath;

enum FileIcons {
    CSV(".csv", "icons/file-csv.png"),
    DOC(".doc", "icons/file-doc.png"),
    DOCX(".docx", "icons/file-docx4.png"),
    UNKNOWN(null, "icons/file-unknown.png"),
    XLS(".xls", "icons/file-xls.png"),
    XLSX(".xlsx", "icons/file-xlsx4.png"),
    TXT(".txt", "icons/file-txt.png"),
    XML(".xml", "icons/file-xml.png");

    private final String suffix;
    private final String iconResource;

    private FileIcons(String suffix, String iconFileName) {
        this.suffix = suffix;
        this.iconResource = FileIcons.class.getResource(iconFileName).toExternalForm();
    }

    ImageView create() {
        ImageView image = new ImageView(this.iconResource);
        image.preserveRatioProperty().set(true);
        image.setFitHeight((double)FileChooserProperties.getIconSize());
        image.getStyleClass().add((Object)"file-icon");
        return image;
    }

    private static ImageView create(String file) {
        if (null == file) {
            return UNKNOWN.create();
        }
        String fileName = file.toLowerCase();
        for (FileIcons icon : FileIcons.values()) {
            String suffix = icon.suffix;
            if (null == icon.suffix || !fileName.endsWith(suffix)) continue;
            return icon.create();
        }
        return UNKNOWN.create();
    }

    static StackPane fromFile(IndexedPath path) {
        return FileIcons.fromFile(path.toString());
    }

    static StackPane fromFile(String file) {
        StackPane pane = new StackPane();
        ImageView image = FileIcons.create(file);
        pane.getChildren().add((Object)image);
        pane.setMinWidth((double)FileChooserProperties.getIconSize() * 1.5);
        pane.getStyleClass().add((Object)"file-icon-pane");
        return pane;
    }
}

