/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.SetChangeListener;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.SVGPath;
import net.raumzeitfalle.fx.filechooser.FileChooserModel;
import net.raumzeitfalle.fx.filechooser.FileChooserViewOption;
import net.raumzeitfalle.fx.filechooser.FilesListCell;
import net.raumzeitfalle.fx.filechooser.HideableView;
import net.raumzeitfalle.fx.filechooser.IndexedPath;
import net.raumzeitfalle.fx.filechooser.LocationMenuItemFactory;
import net.raumzeitfalle.fx.filechooser.PathComparator;
import net.raumzeitfalle.fx.filechooser.PathFilter;
import net.raumzeitfalle.fx.filechooser.PathUpdateHandler;
import net.raumzeitfalle.fx.filechooser.locations.Location;

final class FileChooserController
implements Initializable {
    @FXML
    private SplitMenuButton chooser;
    @FXML
    private MenuItem usersHomeCommand;
    @FXML
    private MenuButton fileExtensionFilter;
    @FXML
    private MenuItem showAllFilesFilter;
    @FXML
    private FlowPane counterPane;
    @FXML
    private Label filteredPathsCount;
    @FXML
    private Label allPathsCount;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private TextField fileNameFilter;
    @FXML
    private ListView<IndexedPath> listOfFiles;
    @FXML
    private TextField selectedFile;
    @FXML
    private Button refreshButton;
    @FXML
    private Button stopButton;
    @FXML
    private MenuButton sortMenu;
    @FXML
    private MenuItem buttonSortAz;
    @FXML
    private MenuItem buttonSortZa;
    @FXML
    private MenuItem buttonSortOldestFirst;
    @FXML
    private MenuItem buttonSortRecentFirst;
    @FXML
    private Button okButton;
    @FXML
    private Button cancelButton;
    @FXML
    private VBox fileChooserView;
    private final FileChooserModel model;
    private final HideableView stage;
    private final BooleanProperty showOkayCancelButtons;
    private final PathUpdateHandler pathSupplier;
    private final LocationMenuItemFactory menuItemFactory;
    private final FileChooserViewOption fileChooserViewOption;
    private final Dialog<Path> dialog;

    public FileChooserController(FileChooserModel fileChooserModel, PathUpdateHandler pathUpdateHandler, FileChooserViewOption fileChooserViewOption, Dialog<Path> dialog) {
        this(fileChooserModel, pathUpdateHandler, null, fileChooserViewOption, dialog);
    }

    public FileChooserController(FileChooserModel fileChooserModel, PathUpdateHandler pathUpdateHandler, HideableView window, FileChooserViewOption fileChooserViewOption, Dialog<Path> dialog) {
        this.model = fileChooserModel;
        this.stage = window;
        this.fileChooserViewOption = fileChooserViewOption;
        this.showOkayCancelButtons = new SimpleBooleanProperty(FileChooserViewOption.STAGE.equals((Object)fileChooserViewOption));
        this.pathSupplier = pathUpdateHandler;
        this.menuItemFactory = new LocationMenuItemFactory(this.model::updateFilesIn);
        this.dialog = dialog;
    }

    @FXML
    public void initialize(URL location, ResourceBundle resources) {
        this.listOfFiles.setItems(this.model.getFilteredPaths());
        this.fileNameFilter.textProperty().addListener(l -> this.handleFileNameFilterChanges());
        StringBinding binding = Bindings.createStringBinding(() -> ((Path)this.model.currentSearchPath().get()).toAbsolutePath().toString(), (Observable[])new Observable[]{this.model.currentSearchPath()});
        this.selectedFile.promptTextProperty().bind((ObservableValue)binding);
        this.listOfFiles.setOnMouseClicked(this::handleDoubleClickInFilesList);
        this.listOfFiles.setCellFactory(e -> new FilesListCell());
        this.listOfFiles.getSelectionModel().selectedItemProperty().addListener(l -> this.model.setSelectedFile(this.selectedItem()));
        this.listOfFiles.setOnKeyPressed(this::handleEnterKeyOnSelection);
        this.selectedFile.textProperty().bind((ObservableValue)this.model.selectedFileNameProperty());
        this.usersHomeCommand.setOnAction(e -> this.model.changeToUsersHome());
        this.showAllFilesFilter.setVisible(false);
        this.model.initializeFilter(this.fileNameFilter.getText());
        this.fileNameFilter.setOnKeyPressed(this::handleKeysForFileNameFilterField);
        this.model.getPathFilter().forEach(this::addNewPathFilterMenuItem);
        this.model.getPathFilter().addListener(this::handlePathFilterModelChange);
        this.model.getLocations().forEach(l -> this.chooser.getItems().add((Object)this.menuItemFactory.apply((Location)l)));
        this.model.getLocations().addListener(this::handleAddedLocation);
        this.chooser.setOnAction(e -> this.changeDirectory());
        this.refreshButton.setOnAction(e -> this.model.refreshFiles());
        this.stopButton.setOnAction(e -> this.model.getUpdateService().cancelUpdate());
        this.assignSortAction(this.buttonSortAz, PathComparator.byName());
        this.assignSortAction(this.buttonSortZa, PathComparator.byName().reversed());
        this.assignSortAction(this.buttonSortOldestFirst, PathComparator.byTimestamp());
        this.assignSortAction(this.buttonSortRecentFirst, PathComparator.byTimestamp().reversed());
        this.buttonSortRecentFirst.setVisible(true);
        this.buttonSortOldestFirst.setVisible(true);
        ReadOnlyBooleanProperty updateIsRunning = this.model.getUpdateService().runningProperty();
        this.progressBar.progressProperty().bind((ObservableValue)this.model.getUpdateService().progressProperty());
        this.counterPane.setVisible(true);
        this.stopButton.visibleProperty().bind((ObservableValue)updateIsRunning);
        this.filteredPathsCount.textProperty().bind((ObservableValue)this.model.filteredPathsSizeProperty().asString());
        this.allPathsCount.textProperty().bind((ObservableValue)this.model.allPathsSizeProperty().asString());
        this.okButton.setOnAction(e -> this.okayAction());
        this.okButton.setOnKeyPressed(this::handleOkayButtonKeyEvents);
        this.cancelButton.setOnAction(e -> this.cancelAction());
        this.okButton.disableProperty().bind((ObservableValue)this.model.invalidSelectionProperty());
        this.okButton.visibleProperty().bind((ObservableValue)this.showOkayCancelButtons);
        this.cancelButton.visibleProperty().bind((ObservableValue)this.showOkayCancelButtons);
        StringBinding sb = Bindings.createStringBinding(() -> {
            Path current = (Path)this.model.currentSearchPath().get();
            if (current != null) {
                return current.normalize().toAbsolutePath().toString();
            }
            return "";
        }, (Observable[])new Observable[]{this.model.currentSearchPath()});
        Tooltip toolTip = new Tooltip();
        toolTip.textProperty().bind((ObservableValue)sb);
        this.chooser.setTooltip(toolTip);
        Platform.runLater(() -> this.fileNameFilter.requestFocus());
    }

    private void handleKeysForFileNameFilterField(KeyEvent keyEvent) {
        if (this.fileNameFilter.getText().equalsIgnoreCase("") && KeyCode.ESCAPE.equals((Object)keyEvent.getCode())) {
            this.cancelAction();
        }
        if (KeyCode.ESCAPE.equals((Object)keyEvent.getCode())) {
            this.fileNameFilter.setText("");
        }
        if (KeyCode.ENTER.equals((Object)keyEvent.getCode())) {
            this.handlePossiblePastedPath();
        }
    }

    private void handlePossiblePastedPath() {
        Path parent;
        Path current;
        Path pastedPath;
        Path updatedPath = pastedPath = (Path)this.model.pastedPathProperty().get();
        if ("..".equals(String.valueOf(pastedPath)) && null != (current = (Path)this.model.currentSearchPath().getValue()) && null != (parent = current.getParent())) {
            updatedPath = parent;
        }
        if (null != updatedPath) {
            this.acceptPathAndSelectFileIfValid(updatedPath);
        } else {
            this.tryManualInputPathSelection();
        }
    }

    private void tryManualInputPathSelection() {
        try {
            this.selectParentPathFromInput();
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
    }

    private void selectParentPathFromInput() {
        Path pasted;
        String pastedText = this.fileNameFilter.getText();
        if (pastedText.isEmpty()) {
            return;
        }
        Path parent = pasted = Paths.get(pastedText, new String[0]);
        if (!Files.exists(pasted, new LinkOption[0]) || !Files.isDirectory(pasted, new LinkOption[0])) {
            parent = pasted.getParent();
        }
        this.selectFirstExistingParentPath(pasted, parent);
    }

    private void selectFirstExistingParentPath(Path pasted, Path parent) {
        boolean parentExists = false;
        while (parent != null && !parentExists) {
            parentExists = Files.exists(parent, new LinkOption[0]);
            if (parentExists) {
                this.model.getUpdateService().restartIn(parent);
                this.fileNameFilter.setText(parent.toString());
                this.fileNameFilter.positionCaret(parent.toString().length() + 1);
            } else {
                parent = pasted.getParent();
            }
            if (parent.toFile().list() == null) {
                Logger.getLogger(FileChooserController.class.getName()).log(Level.SEVERE, "path is not accessible: {0}", parent);
                break;
            }
            this.model.pastedPathProperty().set((Object)parent);
        }
    }

    private void acceptPathAndSelectFileIfValid(Path pastedPath) {
        Path normalized = pastedPath.normalize().toAbsolutePath().normalize();
        this.model.getUpdateService().restartIn(normalized);
        this.fileNameFilter.setText("");
        if (Files.exists(normalized, new LinkOption[0]) && Files.isRegularFile(normalized, new LinkOption[0])) {
            this.selectEnteredFileAndRequestOkayFocus(normalized);
        }
    }

    private void selectEnteredFileAndRequestOkayFocus(Path pastedPath) {
        String fileName = pastedPath.getFileName().toString();
        this.fileNameFilter.setText(fileName);
        this.fileNameFilter.positionCaret(fileName.length() + 1);
        IndexedPath ip = IndexedPath.valueOf(pastedPath);
        this.model.setSelectedFile(ip);
        this.model.pastedPathProperty().set((Object)pastedPath.getParent());
        Platform.runLater(() -> this.okButton.requestFocus());
    }

    private void handleFileNameFilterChanges() {
        this.listOfFiles.getSelectionModel().clearSelection();
        this.model.updateFilterCriterion(this.fileNameFilter.getText());
        this.evaluateIfPathWasEntered();
    }

    private void evaluateIfPathWasEntered() {
        try {
            Path possiblePath = Paths.get(this.fileNameFilter.getText(), new String[0]);
            if (null != possiblePath && possiblePath.toFile().exists()) {
                this.model.pastedPathProperty().set((Object)possiblePath);
            } else {
                this.model.pastedPathProperty().set(null);
            }
        }
        catch (InvalidPathException ipe) {
            this.model.pastedPathProperty().set(null);
        }
    }

    private void handleDoubleClickInFilesList(MouseEvent event) {
        if (event.getClickCount() == 2) {
            this.model.setSelectedFile((IndexedPath)this.listOfFiles.getSelectionModel().getSelectedItem());
            event.consume();
            this.okayAction();
            if (FileChooserViewOption.DIALOG.equals((Object)this.fileChooserViewOption)) {
                this.dialog.setResult((Object)this.model.getSelectedFile());
            }
        }
    }

    private void okayAction() {
        if (this.stage == null) {
            this.okButton.getScene().getWindow().hide();
        } else {
            this.stage.closeView();
        }
    }

    private void cancelAction() {
        this.model.setSelectedFile(null);
        if (this.stage == null) {
            this.cancelButton.getScene().getWindow().hide();
        } else {
            this.stage.closeView();
        }
    }

    private void changeDirectory() {
        Platform.runLater(() -> {
            this.fileChooserView.setDisable(true);
            this.pathSupplier.getUpdate(value -> this.model.getUpdateService().restartIn((Path)value));
            this.fileChooserView.setDisable(false);
        });
    }

    private void handlePathFilterModelChange(ListChangeListener.Change<? extends PathFilter> change) {
        if (change.next()) {
            change.getAddedSubList().forEach(this::addNewPathFilterMenuItem);
            change.getRemoved().forEach(this::removePathFilterMenuItem);
        }
    }

    private void handleAddedLocation(SetChangeListener.Change<? extends Location> change) {
        if (change.wasAdded()) {
            Location added = (Location)change.getElementAdded();
            this.chooser.getItems().add((Object)this.menuItemFactory.apply(added));
        }
    }

    private void addNewPathFilterMenuItem(PathFilter p) {
        Platform.runLater(() -> {
            MenuItem item = new MenuItem(p.getName());
            item.setOnAction(e -> this.model.updateFilterCriterion(p, this.fileNameFilter.getText()));
            this.fileExtensionFilter.getItems().add((Object)item);
        });
    }

    private void removePathFilterMenuItem(PathFilter filterToRemove) {
        Platform.runLater(() -> this.fileExtensionFilter.getItems().removeIf(mi -> mi.getText().equalsIgnoreCase(filterToRemove.getName())));
    }

    private void assignSortAction(MenuItem menuItem, Comparator<IndexedPath> comparator) {
        menuItem.setOnAction(e -> Platform.runLater(() -> {
            this.model.sort(comparator);
            SVGPath svgPath = new SVGPath();
            svgPath.getStyleClass().add((Object)"tool-bar-icon");
            svgPath.setContent(((SVGPath)menuItem.getGraphic()).getContent());
            this.sortMenu.setGraphic((Node)svgPath);
            this.sortMenu.getGraphic().getStyleClass().add((Object)"tool-bar-icon");
        }));
    }

    private IndexedPath selectedItem() {
        return (IndexedPath)this.listOfFiles.getSelectionModel().selectedItemProperty().getValue();
    }

    private void handleOkayButtonKeyEvents(KeyEvent keyEvent) {
        if (KeyCode.ENTER.equals((Object)keyEvent.getCode())) {
            this.okButton.fire();
        }
    }

    private void handleEnterKeyOnSelection(KeyEvent keyevent) {
        if (KeyCode.ENTER.equals((Object)keyevent.getCode()) && !this.listOfFiles.getSelectionModel().isEmpty()) {
            Platform.runLater(() -> this.okButton.requestFocus());
        }
    }

    void stopServices() {
        this.model.getUpdateService().cancelUpdate();
    }
}

