/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextArea;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import net.raumzeitfalle.fx.filechooser.DirectoryChooserOption;
import net.raumzeitfalle.fx.filechooser.FileChooserController;
import net.raumzeitfalle.fx.filechooser.FileChooserModel;
import net.raumzeitfalle.fx.filechooser.FileChooserViewOption;
import net.raumzeitfalle.fx.filechooser.HideableView;
import net.raumzeitfalle.fx.filechooser.PathFilter;
import net.raumzeitfalle.fx.filechooser.PathUpdateHandler;
import net.raumzeitfalle.fx.filechooser.Skin;

public class FileChooser
extends StackPane {
    private FileChooserModel model = FileChooserModel.startingInUsersHome(PathFilter.acceptAllFiles("all files"));
    private FileChooserViewOption viewOption = FileChooserViewOption.STAGE;
    private Skin skin = Skin.MODENA;
    private Dialog<Path> dialog = null;
    private AnchorPane fileChooserView;
    private final FileChooserController controller;

    public FileChooser() {
        this(Skin.DARK, DirectoryChooserOption.JAVAFX_PLATFORM);
    }

    public FileChooser(@NamedArg(value="skin") Skin skin, @NamedArg(value="directoryChooserOption") DirectoryChooserOption directoryChooserOption) {
        if (skin != null) {
            this.skin = skin;
        }
        PathUpdateHandler updateHandler = this.getPathUpdateHandler(directoryChooserOption);
        this.controller = new FileChooserController(this.model, updateHandler, this.viewOption, this.dialog);
        this.loadControl(this.controller);
        Skin.applyTo(this, this.skin);
    }

    FileChooser(@NamedArg(value="model") FileChooserModel model, @NamedArg(value="skin") Skin skin, @NamedArg(value="directoryChooserOption") DirectoryChooserOption directoryChooserOption, @NamedArg(value="viewOption") FileChooserViewOption viewOption, @NamedArg(value="hideableWindow") HideableView hideableWindow) {
        HideableView window = Objects.requireNonNull(hideableWindow);
        this.model = Objects.requireNonNull(model);
        if (skin != null) {
            this.skin = skin;
        }
        PathUpdateHandler updateHandler = this.getPathUpdateHandler(directoryChooserOption);
        this.controller = new FileChooserController(this.model, updateHandler, window, viewOption, this.dialog);
        this.loadControl(this.controller);
        Skin.applyTo(this, this.skin);
    }

    private PathUpdateHandler getPathUpdateHandler(DirectoryChooserOption directoryChooserOption) {
        PathUpdateHandler updateHandler = null;
        updateHandler = directoryChooserOption != null ? (PathUpdateHandler)directoryChooserOption.apply(this) : (PathUpdateHandler)DirectoryChooserOption.JAVAFX_PLATFORM.apply(this);
        return updateHandler;
    }

    FileChooser(PathUpdateHandler handlePath, HideableView window, FileChooserModel model, Skin skin, FileChooserViewOption fileChooserViewOption) {
        this(handlePath, window, model, skin, fileChooserViewOption, null);
    }

    FileChooser(PathUpdateHandler handlePath, HideableView window, FileChooserModel model, Skin skin, FileChooserViewOption fileChooserViewOption, Dialog<Path> dialog) {
        this.model = model;
        this.skin = skin;
        this.viewOption = fileChooserViewOption;
        this.controller = new FileChooserController(this.model, handlePath, window, this.viewOption, this.dialog);
        this.loadControl(this.controller);
        Skin.applyTo(this, this.skin);
    }

    private void loadControl(FileChooserController controller) {
        Parent view;
        Class<?> thisClass = ((Object)((Object)this)).getClass();
        String fileName = thisClass.getSimpleName() + ".fxml";
        URL resource = thisClass.getResource(fileName);
        FXMLLoader loader = new FXMLLoader(resource);
        loader.setController((Object)controller);
        try {
            view = (Parent)loader.load();
        }
        catch (Exception e) {
            view = this.handleErrorOnLoad(fileName, controller, e);
        }
        this.fileChooserView = new AnchorPane();
        this.fileChooserView.getChildren().add((Object)view);
        AnchorPane.setLeftAnchor((Node)view, (Double)0.0);
        AnchorPane.setRightAnchor((Node)view, (Double)0.0);
        AnchorPane.setTopAnchor((Node)view, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)view, (Double)0.0);
        this.getChildren().add((Object)this.fileChooserView);
    }

    private VBox handleErrorOnLoad(String fileName, Object controller, Exception e) {
        StringWriter errors = new StringWriter();
        PrintWriter writer = new PrintWriter(errors);
        writer.println("FXML: " + fileName);
        writer.println("Controller: " + controller.getClass().getName());
        e.printStackTrace(writer);
        TextArea text = new TextArea();
        text.setText(errors.toString());
        VBox.setVgrow((Node)text, (Priority)Priority.ALWAYS);
        VBox box = new VBox();
        box.getChildren().add((Object)text);
        return box;
    }

    public ObjectProperty<Path> currentSearchPath() {
        return this.model.currentSearchPath();
    }

    public Window getWindow() {
        return this.getScene().getWindow();
    }

    public void setEnabled(boolean toggle) {
        this.fileChooserView.setManaged(toggle);
        this.fileChooserView.setVisible(toggle);
    }

    public void shutdown() {
        this.controller.stopServices();
    }
}

