/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.filechooser;

import java.util.function.Function;
import net.raumzeitfalle.fx.dirchooser.DirectoryChooser;
import net.raumzeitfalle.fx.filechooser.FXDirectoryChooser;
import net.raumzeitfalle.fx.filechooser.FileChooser;
import net.raumzeitfalle.fx.filechooser.PathUpdateHandler;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DirectoryChooserOption implements Function<FileChooser, PathUpdateHandler>
{
    JAVAFX_PLATFORM{

        @Override
        public PathUpdateHandler apply(FileChooser fileChooser) {
            return FXDirectoryChooser.createIn(fileChooser.currentSearchPath(), () -> fileChooser.getWindow());
        }
    }
    ,
    CUSTOM{

        @Override
        public PathUpdateHandler apply(FileChooser fileChooser) {
            return new DirectoryChooser.DirChooserPathUpdateHandler(fileChooser);
        }
    };

}

