/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.dirchooser;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;

class ProgressIcon
extends AnchorPane {
    private ProgressBar progressBar = new ProgressBar();

    public ProgressIcon(double iconSize, EventHandler<ActionEvent> cancelHandler) {
        this.progressBar.setProgress(-1.0);
        this.progressBar.setMaxSize(iconSize, iconSize);
        this.progressBar.setPrefSize(iconSize, iconSize);
        this.progressBar.setOnMouseClicked(clickEvent -> {
            if (clickEvent.getClickCount() == 2) {
                cancelHandler.handle(null);
            }
        });
        this.getChildren().add((Object)this.progressBar);
        AnchorPane.setLeftAnchor((Node)this.progressBar, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.progressBar, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.progressBar, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.progressBar, (Double)0.0);
        this.setMinWidth(iconSize * 1.5);
        this.progressBar.getStyleClass().add((Object)"directory-progress-icon");
        this.getStyleClass().add((Object)"directory-icon-pane");
        Tooltip tooltip = new Tooltip("Double click to abort directory search!");
        Tooltip.install((Node)this.progressBar, (Tooltip)tooltip);
    }
}

