/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.dirchooser;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import net.raumzeitfalle.fx.dirchooser.DirectoryTreeItem;

class DirectoryWalker {
    private Path current;
    private int maxDepth;
    private int currentDepth;
    private DirectoryTreeItem rootNode;

    public DirectoryWalker(Path start) {
        this(start, 0);
    }

    public DirectoryWalker(Path start, int maxDepth) {
        this.current = start;
        this.maxDepth = maxDepth;
        this.currentDepth = 0;
        this.rootNode = new DirectoryTreeItem(start);
    }

    DirectoryTreeItem read(ReadOnlyBooleanProperty cancelled) {
        FileFilter ff = pathname -> {
            if (null == pathname) {
                return false;
            }
            return pathname.isDirectory();
        };
        int size = 0;
        for (File f : this.current.toFile().listFiles(ff)) {
            this.addNode(f.toPath(), cancelled);
            ++size;
        }
        this.rootNode.setSize(size);
        return this.rootNode;
    }

    private void addNode(Path path, ReadOnlyBooleanProperty cancelled) {
        if (this.currentDepth <= this.maxDepth) {
            if (cancelled.get()) {
                return;
            }
            DirectoryTreeItem leaf = new DirectoryTreeItem(path);
            this.rootNode.getChildren().add((Object)leaf);
            if (cancelled.get()) {
                return;
            }
            FXCollections.sort((ObservableList)this.rootNode.getChildren(), (a, b) -> ((String)a.getValue()).compareToIgnoreCase((String)b.getValue()));
        }
    }
}

