/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.dirchooser;

import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import net.raumzeitfalle.fx.dirchooser.DirectoryTreeItem;
import net.raumzeitfalle.fx.dirchooser.DirectoryWalker;
import net.raumzeitfalle.fx.dirchooser.ProgressIcon;

class DirectoryTreeUpdateTask
extends Task<Void> {
    private final Path path;
    private final DirectoryTreeItem item;
    private final BooleanProperty cancelled;
    private final Consumer<Path> removable;
    private final Node itemGraphic;

    DirectoryTreeUpdateTask(Path path, DirectoryTreeItem item, Consumer<Path> finalizeAction) {
        this.path = path;
        this.item = item;
        this.cancelled = new SimpleBooleanProperty(false);
        this.removable = finalizeAction;
        this.itemGraphic = item.getGraphic();
    }

    protected Void call() throws Exception {
        DirectoryWalker walker = new DirectoryWalker(this.path);
        ObservableList items = walker.read((ReadOnlyBooleanProperty)this.cancelled).getChildren();
        this.item.getChildren().clear();
        this.item.getChildren().addAll((Collection)items);
        return null;
    }

    protected void running() {
        super.running();
        ProgressIcon progressIcon = new ProgressIcon(32.0, (EventHandler<ActionEvent>)((EventHandler)evt -> this.cancel(true)));
        Platform.runLater(() -> this.item.setGraphic((Node)progressIcon));
    }

    protected void cancelled() {
        Logger.getLogger(DirectoryTreeUpdateTask.class.getName()).log(Level.INFO, "contents discovery in {0}", this.path);
        super.cancelled();
        this.cancelled.setValue(Boolean.valueOf(true));
        this.removable.accept(this.path);
        Platform.runLater(() -> this.item.setGraphic(this.itemGraphic));
    }

    protected void failed() {
        super.failed();
        this.removable.accept(this.path);
        Platform.runLater(() -> this.item.setGraphic(this.itemGraphic));
    }

    protected void succeeded() {
        super.succeeded();
        Platform.runLater(() -> {
            this.item.setGraphic(this.itemGraphic);
            if (!this.item.getChildren().isEmpty() && this.item.isDirectory()) {
                this.item.setExpanded(true);
                this.item.configureIcon();
            }
            this.removable.accept(this.path);
        });
    }
}

