/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.dirchooser;

import java.io.File;
import java.nio.file.Path;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import net.raumzeitfalle.fx.dirchooser.DirectoryIcons;

public class DirectoryTreeItem
extends TreeItem<String> {
    private String fullPath;
    private boolean isDirectory;
    private boolean isDrive;
    private int size = 0;

    public String getFullPath() {
        return this.fullPath;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public DirectoryTreeItem(String root) {
        super((Object)root);
    }

    public DirectoryTreeItem(Path file) {
        super((Object)file.toString());
        this.fullPath = file.toString();
        this.isDirectory = file.toFile().isDirectory();
        this.isDrive = this.determineIfIsDrive();
        String[] contents = new File(this.fullPath).list();
        if (contents != null) {
            this.size = contents.length;
        }
        this.configureIcon();
        if (!this.fullPath.endsWith(File.separator)) {
            String value = file.toString();
            int indexOf = value.lastIndexOf(File.separator);
            if (indexOf > -1) {
                this.setValue(value.substring(indexOf + 1));
            } else {
                this.setValue(value);
            }
        }
        this.addEventHandler(TreeItem.branchExpandedEvent(), this::handleExpansion);
        this.addEventHandler(TreeItem.branchCollapsedEvent(), this::handleCollapse);
    }

    public void configureIcon() {
        if (this.isExpanded()) {
            this.configureExpandedIcon();
        } else {
            this.configureCollapsedIcon();
        }
    }

    private void configureCollapsedIcon() {
        if (this.isDrive && !this.getChildren().isEmpty()) {
            this.setGraphic((Node)DirectoryIcons.DRIVE_PLUS.get());
        } else if (this.isDrive && this.size == 0) {
            this.setGraphic((Node)DirectoryIcons.DRIVE_EMPTY.get());
        } else if (this.isDrive && this.size > 1000) {
            this.setGraphic((Node)DirectoryIcons.DRIVE_XL.get());
        } else if (this.isDrive) {
            this.setGraphic((Node)DirectoryIcons.DRIVE.get());
        } else if (this.getChildren().isEmpty() && this.size > 1000) {
            this.setGraphic((Node)DirectoryIcons.NO_SUBDIRS_XL.get());
        } else if (this.size == 0) {
            this.setGraphic((Node)DirectoryIcons.EMPTY.get());
        } else if (this.getChildren().size() > 1000) {
            this.setGraphic((Node)DirectoryIcons.CLOSED_XL.get());
        } else if (!this.getChildren().isEmpty()) {
            this.setGraphic((Node)DirectoryIcons.CLOSED_PLUS.get());
        } else {
            this.setGraphic((Node)DirectoryIcons.CLOSED.get());
        }
    }

    private void configureExpandedIcon() {
        if (!this.isDrive) {
            this.setGraphic((Node)DirectoryIcons.OPEN.get());
        }
    }

    public boolean isDrive() {
        return this.isDrive;
    }

    private boolean determineIfIsDrive() {
        if (this.fullPath.length() != 3) {
            return false;
        }
        if (!Character.isAlphabetic(this.fullPath.charAt(0))) {
            return false;
        }
        if (this.fullPath.charAt(1) != ':') {
            return false;
        }
        return this.fullPath.charAt(2) == '\\' || this.fullPath.charAt(2) == '/';
    }

    private void handleExpansion(Event e) {
        DirectoryTreeItem item = (DirectoryTreeItem)((Object)e.getSource());
        item.configureIcon();
    }

    private void handleCollapse(Event e) {
        DirectoryTreeItem item = (DirectoryTreeItem)((Object)e.getSource());
        if (null != item) {
            item.configureIcon();
        }
    }

    boolean isHuge() {
        return (long)this.size > 1000L;
    }

    public int size() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

