/*
 * Decompiled with CFR 0.152.
 */
package net.raumzeitfalle.fx.dirchooser;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TextArea;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.raumzeitfalle.fx.dirchooser.DirectoryChooserController;
import net.raumzeitfalle.fx.filechooser.FileChooser;
import net.raumzeitfalle.fx.filechooser.PathUpdateHandler;
import net.raumzeitfalle.fx.filechooser.Skin;

public class DirectoryChooser
extends AnchorPane {
    private final DirectoryChooserController controller;
    private final BooleanProperty useChooseFileButtonProperty;
    private final BooleanProperty useCancelButtonProperty;

    public DirectoryChooser() {
        this(Skin.DARK);
    }

    public DirectoryChooser(@NamedArg(value="skin") Skin skin) {
        Parent view;
        Class<?> thisClass = ((Object)((Object)this)).getClass();
        String fileName = thisClass.getSimpleName() + ".fxml";
        URL resource = thisClass.getResource(fileName);
        FXMLLoader loader = new FXMLLoader(resource);
        this.controller = new DirectoryChooserController();
        loader.setController((Object)this.controller);
        try {
            view = (Parent)loader.load();
        }
        catch (Exception e) {
            view = this.handleErrorOnLoad(fileName, e);
        }
        this.getChildren().add((Object)view);
        AnchorPane.setLeftAnchor((Node)view, (Double)0.0);
        AnchorPane.setRightAnchor((Node)view, (Double)0.0);
        AnchorPane.setTopAnchor((Node)view, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)view, (Double)0.0);
        Skin.applyTo(this, skin);
        this.controller.hideChooseFilesButton();
        this.useChooseFileButtonProperty = new SimpleBooleanProperty(false);
        this.useChooseFileButtonProperty.addListener((obs, prev, next) -> {
            if (Boolean.compare(next, prev) == 0) {
                return;
            }
            this.controller.setUseChooseFilesButton((boolean)next);
        });
        this.controller.hideCancelButton();
        this.useCancelButtonProperty = new SimpleBooleanProperty(false);
        this.useCancelButtonProperty.addListener((obs, prev, next) -> {
            if (Boolean.compare(next, prev) == 0) {
                return;
            }
            this.controller.setUseCancelButton((boolean)next);
        });
    }

    private VBox handleErrorOnLoad(String fileName, Exception e) {
        StringWriter errors = new StringWriter();
        PrintWriter writer = new PrintWriter(errors);
        writer.println("FXML: " + fileName);
        writer.println("Controller: " + this.controller.getClass().getName());
        e.printStackTrace(writer);
        TextArea text = new TextArea();
        text.setText(errors.toString());
        VBox.setVgrow((Node)text, (Priority)Priority.ALWAYS);
        VBox box = new VBox();
        box.getChildren().add((Object)text);
        return box;
    }

    public ReadOnlyObjectProperty<Path> selectedDirectoryProperty() {
        return this.controller.selectedDirectoryProperty();
    }

    public BooleanProperty useChooseFileButtonProperty() {
        return this.useChooseFileButtonProperty;
    }

    public BooleanProperty useCancelButtonProperty() {
        return this.useCancelButtonProperty;
    }

    public void onSelect(Runnable action) {
        this.controller.setOnSelect(action);
    }

    public void onCancel(Runnable action) {
        this.controller.setOnCancel(action);
    }

    public void shutdown() {
        this.controller.shutdown();
    }

    public void setEnabled(boolean toggle) {
        this.setManaged(toggle);
        this.setVisible(toggle);
    }

    public static class DirChooserPathUpdateHandler
    implements PathUpdateHandler {
        private final DirectoryChooser dirChooser;
        private final FileChooser fileChooser;

        public DirChooserPathUpdateHandler(FileChooser fileChooser) {
            this.fileChooser = Objects.requireNonNull(fileChooser);
            this.dirChooser = new DirectoryChooser();
            this.fileChooser.getChildren().add((Object)this.dirChooser);
            this.dirChooser.setEnabled(false);
            this.dirChooser.useChooseFileButtonProperty.setValue(Boolean.valueOf(true));
            this.dirChooser.useCancelButtonProperty.setValue(Boolean.valueOf(true));
        }

        @Override
        public void getUpdate(Consumer<Path> update) {
            Platform.runLater(() -> {
                this.dirChooser.setEnabled(true);
                this.fileChooser.setEnabled(false);
            });
            this.dirChooser.onSelect(() -> {
                Path selectedDir = (Path)this.dirChooser.selectedDirectoryProperty().get();
                if (null != selectedDir) {
                    update.accept(selectedDir);
                }
                this.dirChooser.setEnabled(false);
                this.fileChooser.setEnabled(true);
            });
            this.dirChooser.onCancel(() -> {
                this.dirChooser.setEnabled(false);
                this.fileChooser.setEnabled(true);
            });
        }
    }
}

