/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.javadowngrader.util;

public enum JavaVersion {
    JAVA_8("8", 52),
    JAVA_9("9", 53),
    JAVA_10("10", 54),
    JAVA_11("11", 55),
    JAVA_12("12", 56),
    JAVA_13("13", 57),
    JAVA_14("14", 58),
    JAVA_15("15", 59),
    JAVA_16("16", 60),
    JAVA_17("17", 61),
    JAVA_18("18", 62),
    JAVA_19("19", 63),
    JAVA_20("20", 64),
    JAVA_21("21", 65);

    private final String name;
    private final int version;

    private JavaVersion(String name, int version) {
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFakeJavaVersionName() {
        if (this.ordinal() <= JAVA_8.ordinal()) {
            return "1." + this.name + ".0";
        }
        return this.version + ".0.0";
    }

    public String getFakeSpecificationVersionName() {
        if (this.ordinal() <= JAVA_8.ordinal()) {
            return "1." + this.name;
        }
        return this.name;
    }

    public static JavaVersion getByName(String name) {
        name = name.toLowerCase().replace("java", "").replace("j", "");
        for (JavaVersion version : JavaVersion.values()) {
            if (!version.getName().equalsIgnoreCase(name)) continue;
            return version;
        }
        return null;
    }
}

