/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.javadowngrader.util;

import java.lang.reflect.Modifier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMUtil {
    public static int getFreeVarIndex(MethodNode methodNode) {
        int currentIndex = 0;
        if (!Modifier.isStatic(methodNode.access)) {
            currentIndex = 1;
        }
        for (Type arg : Type.getArgumentTypes((String)methodNode.desc)) {
            currentIndex += arg.getSize();
        }
        for (AbstractInsnNode instruction : methodNode.instructions) {
            if (instruction.getOpcode() >= 54 && instruction.getOpcode() <= 58 || instruction.getOpcode() >= 21 && instruction.getOpcode() <= 25) {
                VarInsnNode varInsnNode = (VarInsnNode)instruction;
                if (varInsnNode.var <= currentIndex) continue;
                currentIndex = varInsnNode.var;
                continue;
            }
            if (instruction.getOpcode() != 132) continue;
            IincInsnNode iincInsnNode = (IincInsnNode)instruction;
            if (iincInsnNode.var <= currentIndex) continue;
            currentIndex = iincInsnNode.var;
        }
        return currentIndex + 2;
    }

    public static boolean hasMethod(ClassNode classNode, String name, String desc) {
        return ASMUtil.getMethod(classNode, name, desc) != null;
    }

    public static MethodNode getMethod(ClassNode classNode, String name, String desc) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(name) || !methodNode.desc.equals(desc)) continue;
            return methodNode;
        }
        return null;
    }
}

