/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.javadowngrader.transformer.j8;

import net.raphimc.javadowngrader.transformer.DowngradeResult;
import net.raphimc.javadowngrader.transformer.DowngradingTransformer;
import net.raphimc.javadowngrader.transformer.j8.StringConcatFactoryReplacer;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.BufferMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.ClassGetModuleMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.InputStreamReadAllBytesMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.InputStreamTransferToMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.ListOfMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.MapEntryMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.MapOfEntriesMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.MapOfMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.MatcherAppendReplacementMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.MatcherAppendTailMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.MathFloorModMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.ObjectsRequireNonNullElseGetMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.ObjectsRequireNonNullElseMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.OptionalIfPresentOrElseMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.OptionalOrMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.OptionalStreamMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.RuntimeVersionMCR;
import net.raphimc.javadowngrader.transformer.j8.methodcallreplacer.SetOfMCR;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class Java9ToJava8
extends DowngradingTransformer {
    public Java9ToJava8() {
        super(53, 52);
        String[] bufferClasses;
        this.addMethodCallReplacer(184, "java/util/List", "of", new ListOfMCR());
        this.addMethodCallReplacer(184, "java/util/Set", "of", new SetOfMCR());
        this.addMethodCallReplacer(184, "java/util/Map", "of", new MapOfMCR());
        this.addMethodCallReplacer(184, "java/util/Map", "entry", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;", new MapEntryMCR());
        this.addMethodCallReplacer(184, "java/util/Map", "ofEntries", "([Ljava/util/Map$Entry;)Ljava/util/Map;", new MapOfEntriesMCR());
        this.addMethodCallReplacer(182, "java/io/InputStream", "transferTo", "(Ljava/io/OutputStream;)J", new InputStreamTransferToMCR());
        this.addMethodCallReplacer(182, "java/io/ByteArrayInputStream", "transferTo", "(Ljava/io/OutputStream;)J", new InputStreamTransferToMCR());
        this.addMethodCallReplacer(182, "java/io/InputStream", "readAllBytes", "()[B", new InputStreamReadAllBytesMCR());
        this.addMethodCallReplacer(182, "java/io/FileInputStream", "readAllBytes", "()[B", new InputStreamReadAllBytesMCR());
        this.addMethodCallReplacer(182, "java/io/ByteArrayInputStream", "readAllBytes", "()[B", new InputStreamReadAllBytesMCR());
        this.addMethodCallReplacer(184, "java/util/Objects", "requireNonNullElse", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", new ObjectsRequireNonNullElseMCR());
        this.addMethodCallReplacer(184, "java/util/Objects", "requireNonNullElseGet", "(Ljava/lang/Object;Ljava/util/function/Supplier;)Ljava/lang/Object;", new ObjectsRequireNonNullElseGetMCR());
        for (String bufferClass : bufferClasses = new String[]{"java/nio/ByteBuffer", "java/nio/ShortBuffer", "java/nio/CharBuffer", "java/nio/IntBuffer", "java/nio/FloatBuffer", "java/nio/DoubleBuffer", "java/nio/LongBuffer"}) {
            this.addMethodCallReplacer(182, bufferClass, "flip", "()L" + bufferClass + ';', new BufferMCR(bufferClass));
            this.addMethodCallReplacer(182, bufferClass, "clear", "()L" + bufferClass + ';', new BufferMCR(bufferClass));
            this.addMethodCallReplacer(182, bufferClass, "mark", "()L" + bufferClass + ';', new BufferMCR(bufferClass));
            this.addMethodCallReplacer(182, bufferClass, "reset", "()L" + bufferClass + ';', new BufferMCR(bufferClass));
            this.addMethodCallReplacer(182, bufferClass, "rewind", "()L" + bufferClass + ';', new BufferMCR(bufferClass));
            this.addMethodCallReplacer(182, bufferClass, "limit", "()L" + bufferClass + ';', new BufferMCR(bufferClass));
            this.addMethodCallReplacer(182, bufferClass, "limit", "(I)L" + bufferClass + ';', new BufferMCR(bufferClass));
            this.addMethodCallReplacer(182, bufferClass, "position", "(I)L" + bufferClass + ';', new BufferMCR(bufferClass));
        }
        this.addMethodCallReplacer(182, "java/util/Optional", "or", "(Ljava/util/function/Supplier;)Ljava/util/Optional;", new OptionalOrMCR());
        this.addMethodCallReplacer(182, "java/util/regex/Matcher", "appendReplacement", "(Ljava/lang/StringBuilder;Ljava/lang/String;)Ljava/util/regex/Matcher;", new MatcherAppendReplacementMCR());
        this.addMethodCallReplacer(182, "java/util/regex/Matcher", "appendTail", "(Ljava/lang/StringBuilder;)Ljava/lang/StringBuilder;", new MatcherAppendTailMCR());
        this.addClassReplacementWithExtraDeps("java/lang/StackWalker", "java/lang/StackWalker$Option");
        this.addClassReplacement("java/lang/StackWalker$Option");
        this.addMethodCallReplacer(182, "java/lang/Class", "getModule", "()Ljava/lang/Module;", new ClassGetModuleMCR());
        this.addClassReplacement("java/lang/Module");
        this.addClassReplacement("java/lang/ModuleLayer");
        this.addMethodCallReplacer(184, "java/lang/Math", "floorMod", "(JI)I", new MathFloorModMCR());
        this.addMethodCallReplacer(182, "java/util/Optional", "ifPresentOrElse", new OptionalIfPresentOrElseMCR());
        this.addMethodCallReplacer(182, "java/util/Optional", "stream", new OptionalStreamMCR("", "Ljava/lang/Object;"));
        this.addMethodCallReplacer(182, "java/util/OptionalInt", "stream", new OptionalStreamMCR("Int", "I"));
        this.addMethodCallReplacer(182, "java/util/OptionalLong", "stream", new OptionalStreamMCR("Long", "J"));
        this.addMethodCallReplacer(182, "java/util/OptionalDouble", "stream", new OptionalStreamMCR("Double", "D"));
        this.addMethodCallReplacer(184, "java/lang/Runtime", "version", new RuntimeVersionMCR());
        this.addClassReplacementWithExtraDeps("java/lang/Runtime$Version", "java/lang/Runtime$VersionPattern");
    }

    @Override
    protected void preTransform(ClassNode classNode, DowngradeResult result) {
        StringConcatFactoryReplacer.replace(classNode);
        this.makeInterfaceMethodsPublic(classNode);
    }

    private void makeInterfaceMethodsPublic(ClassNode classNode) {
        if ((classNode.access & 0x200) != 0) {
            for (MethodNode method : classNode.methods) {
                if ((method.access & 2) != 0) {
                    method.access &= 0xFFFFFFFD;
                }
                method.access |= 1;
            }
        }
    }
}

