/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.javadowngrader.transformer.j15;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.raphimc.javadowngrader.util.ASMUtil;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.RecordComponentNode;

public class RecordReplacer {
    private static final String EQUALS_DESC = "(Ljava/lang/Object;)Z";
    private static final String HASHCODE_DESC = "()I";
    private static final String TOSTRING_DESC = "()Ljava/lang/String;";
    private static final Map<String, String> PRIMITIVE_WRAPPERS = new HashMap<String, String>();

    public static boolean replace(ClassNode classNode) {
        MethodNode defaultToString;
        MethodNode defaultHashCode;
        MethodNode defaultEquals;
        if (!Objects.equals(classNode.superName, "java/lang/Record")) {
            return false;
        }
        classNode.access &= 0xFFFEFFFF;
        if (classNode.signature != null) {
            classNode.signature = classNode.signature.replace("Ljava/lang/Record;", "Ljava/lang/Object;");
        }
        if (classNode.recordComponents == null) {
            classNode.recordComponents = Collections.emptyList();
        }
        if ((defaultEquals = ASMUtil.getMethod(classNode, "equals", EQUALS_DESC)) == null) {
            throw new IllegalStateException("Could not find default equals method");
        }
        RecordField[] equalsFields = RecordReplacer.getFields(defaultEquals);
        if (equalsFields != null) {
            classNode.methods.remove(defaultEquals);
            MethodVisitor equals = classNode.visitMethod(1, "equals", EQUALS_DESC, null, null);
            equals.visitCode();
            equals.visitVarInsn(25, 0);
            equals.visitVarInsn(25, 1);
            Label notSameLabel = new Label();
            equals.visitJumpInsn(166, notSameLabel);
            equals.visitInsn(4);
            equals.visitInsn(172);
            equals.visitLabel(notSameLabel);
            equals.visitVarInsn(25, 1);
            equals.visitTypeInsn(193, classNode.name);
            Label notIsInstanceLabel = new Label();
            equals.visitJumpInsn(154, notIsInstanceLabel);
            equals.visitInsn(3);
            equals.visitInsn(172);
            equals.visitLabel(notIsInstanceLabel);
            equals.visitVarInsn(25, 1);
            equals.visitTypeInsn(192, classNode.name);
            equals.visitVarInsn(58, 2);
            Label notEqualLabel = new Label();
            RecordField[] recordFieldArray = equalsFields;
            int n = recordFieldArray.length;
            for (int i = 0; i < n; ++i) {
                RecordField field = recordFieldArray[i];
                equals.visitVarInsn(25, 0);
                equals.visitFieldInsn(180, classNode.name, field.name, field.descriptor);
                equals.visitVarInsn(25, 2);
                equals.visitFieldInsn(180, classNode.name, field.name, field.descriptor);
                if (Type.getType((String)field.descriptor).getSort() >= 9) {
                    equals.visitMethodInsn(184, Type.getInternalName(Objects.class), "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
                    equals.visitJumpInsn(153, notEqualLabel);
                    continue;
                }
                if ("BSCIZ".contains(field.descriptor)) {
                    equals.visitJumpInsn(160, notEqualLabel);
                    continue;
                }
                if (field.descriptor.equals("F")) {
                    equals.visitMethodInsn(184, Type.getInternalName(Float.class), "compare", "(FF)I", false);
                } else if (field.descriptor.equals("D")) {
                    equals.visitMethodInsn(184, Type.getInternalName(Double.class), "compare", "(DD)I", false);
                } else if (field.descriptor.equals("J")) {
                    equals.visitInsn(148);
                } else {
                    throw new AssertionError((Object)("Unknown descriptor " + field.descriptor));
                }
                equals.visitJumpInsn(154, notEqualLabel);
            }
            equals.visitInsn(4);
            equals.visitInsn(172);
            equals.visitLabel(notEqualLabel);
            equals.visitInsn(3);
            equals.visitInsn(172);
            equals.visitEnd();
        }
        if ((defaultHashCode = ASMUtil.getMethod(classNode, "hashCode", HASHCODE_DESC)) == null) {
            throw new IllegalStateException("Could not find default hashCode method");
        }
        Label hashCodeFields = RecordReplacer.getFields(defaultHashCode);
        if (hashCodeFields != null) {
            classNode.methods.remove(defaultHashCode);
            MethodVisitor hashCode = classNode.visitMethod(1, "hashCode", HASHCODE_DESC, null, null);
            hashCode.visitCode();
            hashCode.visitInsn(3);
            for (RecordField field : hashCodeFields) {
                hashCode.visitIntInsn(16, 31);
                hashCode.visitInsn(104);
                hashCode.visitVarInsn(25, 0);
                hashCode.visitFieldInsn(180, classNode.name, field.name, field.descriptor);
                String owner = PRIMITIVE_WRAPPERS.get(field.descriptor);
                hashCode.visitMethodInsn(184, owner != null ? owner : "java/util/Objects", "hashCode", "(" + (owner != null ? field.descriptor : "Ljava/lang/Object;") + ")I", false);
                hashCode.visitInsn(96);
            }
            hashCode.visitInsn(172);
            hashCode.visitEnd();
        }
        if ((defaultToString = ASMUtil.getMethod(classNode, "toString", TOSTRING_DESC)) == null) {
            throw new IllegalStateException("Could not find default toString method");
        }
        RecordField[] toStringFields = RecordReplacer.getFields(defaultToString);
        if (toStringFields != null) {
            int i;
            classNode.methods.remove(defaultToString);
            MethodVisitor toString = classNode.visitMethod(1, "toString", TOSTRING_DESC, null, null);
            toString.visitCode();
            StringBuilder formatString = new StringBuilder("%s[");
            for (i = 0; i < classNode.recordComponents.size(); ++i) {
                formatString.append(((RecordComponentNode)classNode.recordComponents.get((int)i)).name).append("=%s");
                if (i == classNode.recordComponents.size() - 1) continue;
                formatString.append(", ");
            }
            formatString.append(']');
            toString.visitLdcInsn((Object)formatString.toString());
            toString.visitIntInsn(17, classNode.recordComponents.size() + 1);
            toString.visitTypeInsn(189, "java/lang/Object");
            toString.visitInsn(89);
            toString.visitInsn(3);
            toString.visitVarInsn(25, 0);
            toString.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
            toString.visitMethodInsn(182, "java/lang/Class", "getSimpleName", TOSTRING_DESC, false);
            toString.visitInsn(83);
            i = 1;
            for (RecordField field : toStringFields) {
                toString.visitInsn(89);
                toString.visitIntInsn(17, i);
                toString.visitVarInsn(25, 0);
                toString.visitFieldInsn(180, classNode.name, field.name, field.descriptor);
                String owner = PRIMITIVE_WRAPPERS.get(field.descriptor);
                toString.visitMethodInsn(184, owner != null ? owner : "java/util/Objects", "toString", "(" + (owner != null ? field.descriptor : "Ljava/lang/Object;") + ")Ljava/lang/String;", false);
                toString.visitInsn(83);
                ++i;
            }
            toString.visitMethodInsn(184, "java/lang/String", "format", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
            toString.visitInsn(176);
            toString.visitEnd();
        }
        classNode.recordComponents = null;
        return true;
    }

    private static RecordField[] getFields(MethodNode method) {
        for (AbstractInsnNode instruction : method.instructions) {
            if (!(instruction instanceof InvokeDynamicInsnNode)) continue;
            InvokeDynamicInsnNode invokeDynamic = (InvokeDynamicInsnNode)instruction;
            if (!invokeDynamic.bsm.getOwner().equals("java/lang/runtime/ObjectMethods") || !invokeDynamic.bsm.getName().equals("bootstrap") || !invokeDynamic.bsm.getDesc().equals("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/TypeDescriptor;Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/invoke/MethodHandle;)Ljava/lang/Object;")) continue;
            ArrayList<RecordField> fields = new ArrayList<RecordField>();
            for (int i = 2; i < invokeDynamic.bsmArgs.length; ++i) {
                if (!(invokeDynamic.bsmArgs[i] instanceof Handle)) {
                    throw new IllegalStateException("bsm arg " + i + " is not a handle");
                }
                Handle handle = (Handle)invokeDynamic.bsmArgs[i];
                fields.add(new RecordField(handle.getName(), handle.getDesc()));
            }
            return fields.toArray(new RecordField[0]);
        }
        return null;
    }

    static {
        PRIMITIVE_WRAPPERS.put("V", Type.getInternalName(Void.class));
        PRIMITIVE_WRAPPERS.put("Z", Type.getInternalName(Boolean.class));
        PRIMITIVE_WRAPPERS.put("B", Type.getInternalName(Byte.class));
        PRIMITIVE_WRAPPERS.put("S", Type.getInternalName(Short.class));
        PRIMITIVE_WRAPPERS.put("C", Type.getInternalName(Character.class));
        PRIMITIVE_WRAPPERS.put("I", Type.getInternalName(Integer.class));
        PRIMITIVE_WRAPPERS.put("F", Type.getInternalName(Float.class));
        PRIMITIVE_WRAPPERS.put("J", Type.getInternalName(Long.class));
        PRIMITIVE_WRAPPERS.put("D", Type.getInternalName(Double.class));
    }

    private static class RecordField {
        private final String name;
        private final String descriptor;

        private RecordField(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }
    }
}

