/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.javadowngrader.transformer.j11.methodcallreplacer;

import java.lang.reflect.Modifier;
import net.raphimc.javadowngrader.RuntimeDepCollector;
import net.raphimc.javadowngrader.transformer.DowngradeResult;
import net.raphimc.javadowngrader.transformer.MethodCallReplacer;
import net.raphimc.javadowngrader.util.ASMUtil;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CompletableFutureExceptionallyAsyncMCR
implements MethodCallReplacer {
    private static final String handleBiFunctionName = "javadowngrader-exceptionallyAsync-handleBiFunction";
    private static final String handleBiFunctionDescriptor = "(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Function;Ljava/util/concurrent/Executor;Ljava/lang/Object;Ljava/lang/Throwable;)Ljava/util/concurrent/CompletableFuture;";
    private static final String handleAsyncBiFunctionName = "javadowngrader-exceptionallyAsync-handleAsyncBiFunction";
    private static final String handleAsyncBiFunctionDescriptor = "(Ljava/util/function/Function;Ljava/lang/Object;Ljava/lang/Throwable;)Ljava/lang/Object;";

    @Override
    public InsnList getReplacement(ClassNode classNode, MethodNode method, String originalName, String originalDesc, RuntimeDepCollector depCollector, DowngradeResult result) {
        boolean isInterface = Modifier.isInterface(classNode.access);
        MethodNode handleBiFunctionBody = this.makeHandleBiFunctionBody(classNode, isInterface);
        MethodNode handleAsyncBiFunctionBody = this.makeHandleAsyncBiFunctionBody();
        classNode.methods.add(handleBiFunctionBody);
        classNode.methods.add(handleAsyncBiFunctionBody);
        int freeVarIndex = ASMUtil.getFreeVarIndex(method);
        InsnList replacement = new InsnList();
        replacement.add((AbstractInsnNode)new VarInsnNode(58, freeVarIndex + 2));
        replacement.add((AbstractInsnNode)new VarInsnNode(58, freeVarIndex + 1));
        replacement.add((AbstractInsnNode)new VarInsnNode(58, freeVarIndex));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, freeVarIndex));
        replacement.add((AbstractInsnNode)new InsnNode(89));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, freeVarIndex + 1));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, freeVarIndex + 2));
        replacement.add((AbstractInsnNode)new InvokeDynamicInsnNode("apply", "(Ljava/util/concurrent/CompletableFuture;Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/function/BiFunction;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Object[]{Type.getType((String)"(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"), new Handle(6, classNode.name, handleBiFunctionName, handleBiFunctionDescriptor, isInterface), Type.getType((String)"(Ljava/lang/Object;Ljava/lang/Throwable;)Ljava/util/concurrent/CompletableFuture;")}));
        replacement.add((AbstractInsnNode)new MethodInsnNode(182, "java/util/concurrent/CompletableFuture", "handle", "(Ljava/util/function/BiFunction;)Ljava/util/concurrent/CompletableFuture;"));
        replacement.add((AbstractInsnNode)new MethodInsnNode(184, "java/util/function/Function", "identity", "()Ljava/util/function/Function;", true));
        replacement.add((AbstractInsnNode)new MethodInsnNode(182, "java/util/concurrent/CompletableFuture", "thenCompose", "(Ljava/util/function/Function;)Ljava/util/concurrent/CompletableFuture;"));
        result.setRequiresStackMapFrames();
        return replacement;
    }

    private MethodNode makeHandleBiFunctionBody(ClassNode classNode, boolean isInterface) {
        LabelNode isNullJump = new LabelNode();
        MethodNode lambda = new MethodNode(4106, handleBiFunctionName, handleBiFunctionDescriptor, null, null);
        lambda.instructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
        lambda.instructions.add((AbstractInsnNode)new JumpInsnNode(198, isNullJump));
        lambda.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        lambda.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        lambda.instructions.add((AbstractInsnNode)new InvokeDynamicInsnNode("apply", "(Ljava/util/function/Function;)Ljava/util/function/BiFunction;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Object[]{Type.getType((String)"(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"), new Handle(6, classNode.name, handleAsyncBiFunctionName, handleAsyncBiFunctionDescriptor, isInterface), Type.getType((String)"(Ljava/lang/Object;Ljava/lang/Throwable;)Ljava/util/concurrent/CompletableFuture;")}));
        lambda.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
        lambda.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "java/util/concurrent/CompletableFuture", "handleAsync", "(Ljava/util/function/BiFunction;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"));
        lambda.instructions.add((AbstractInsnNode)new InsnNode(176));
        lambda.instructions.add((AbstractInsnNode)isNullJump);
        lambda.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        lambda.instructions.add((AbstractInsnNode)new InsnNode(176));
        return lambda;
    }

    private MethodNode makeHandleAsyncBiFunctionBody() {
        MethodNode lambda = new MethodNode(4106, handleAsyncBiFunctionName, handleAsyncBiFunctionDescriptor, null, null);
        lambda.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        lambda.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
        lambda.instructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/function/Function", "apply", "(Ljava/lang/Object;)Ljava/lang/Object;"));
        lambda.instructions.add((AbstractInsnNode)new InsnNode(176));
        return lambda;
    }
}

