/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.javadowngrader.transformer.j10;

import net.raphimc.javadowngrader.transformer.DowngradeResult;
import net.raphimc.javadowngrader.transformer.DowngradingTransformer;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.CharacterToStringMCR;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.FilesReadStringMCR;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.InflaterInflateMCR;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.InflaterSetInputMCR;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.ListToArrayMCR;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.OptionalIsEmptyMCR;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.OutputStreamNullOutputStreamMCR;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.PathOfMCR;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.StringIsBlankMCR;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.StringStripLeadingMCR;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.StringStripMCR;
import net.raphimc.javadowngrader.transformer.j10.methodcallreplacer.StringStripTrailingMCR;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class Java11ToJava10
extends DowngradingTransformer {
    public Java11ToJava10() {
        super(55, 54);
        String[] optionalClasses;
        this.addMethodCallReplacer(182, "java/lang/String", "isBlank", "()Z", new StringIsBlankMCR());
        this.addMethodCallReplacer(182, "java/lang/String", "strip", "()Ljava/lang/String;", new StringStripMCR());
        this.addMethodCallReplacer(182, "java/lang/String", "stripLeading", "()Ljava/lang/String;", new StringStripLeadingMCR());
        this.addMethodCallReplacer(182, "java/lang/String", "stripTrailing", "()Ljava/lang/String;", new StringStripTrailingMCR());
        this.addMethodCallReplacer(184, "java/nio/file/Files", "readString", new FilesReadStringMCR());
        this.addMethodCallReplacer(184, "java/nio/file/Path", "of", new PathOfMCR());
        for (String optionalClass : optionalClasses = new String[]{"java/util/Optional", "java/util/OptionalDouble", "java/util/OptionalInt", "java/util/OptionalLong"}) {
            this.addMethodCallReplacer(182, optionalClass, "isEmpty", "()Z", new OptionalIsEmptyMCR(optionalClass));
        }
        this.addMethodCallReplacer(185, "java/util/List", "toArray", "(Ljava/util/function/IntFunction;)[Ljava/lang/Object;", new ListToArrayMCR());
        this.addMethodCallReplacer(184, "java/lang/Character", "toString", "(I)Ljava/lang/String;", new CharacterToStringMCR());
        this.addMethodCallReplacer(182, "java/util/zip/Inflater", "setInput", "(Ljava/nio/ByteBuffer;)V", new InflaterSetInputMCR());
        this.addMethodCallReplacer(182, "java/util/zip/Inflater", "inflate", "(Ljava/nio/ByteBuffer;)I", new InflaterInflateMCR());
        this.addMethodCallReplacer(184, "java/io/OutputStream", "nullOutputStream", "()Ljava/io/OutputStream;", new OutputStreamNullOutputStreamMCR());
    }

    @Override
    protected void preTransform(ClassNode classNode, DowngradeResult result) {
        this.makePackagePrivate(classNode);
    }

    private void makePackagePrivate(ClassNode classNode) {
        if (classNode.nestHostClass == null && classNode.nestMembers == null) {
            return;
        }
        for (MethodNode methodNode : classNode.methods) {
            methodNode.access &= 0xFFFFFFFD;
        }
        for (FieldNode fieldNode : classNode.fields) {
            fieldNode.access &= 0xFFFFFFFD;
        }
        classNode.nestHostClass = null;
        classNode.nestMembers = null;
    }
}

