/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.javadowngrader.transformer;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.raphimc.javadowngrader.RuntimeDepCollector;
import net.raphimc.javadowngrader.transformer.DowngradeResult;
import net.raphimc.javadowngrader.transformer.MethodCallReplacer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class DowngradingTransformer {
    private static final String BRIDGE_PREFIX = "javadowngrader-bridge$";
    private final int sourceVersion;
    private final int targetVersion;
    private final Map<String, MethodCallReplacer> methodCallReplacers = new HashMap<String, MethodCallReplacer>();
    private final Map<String, ClassReplacement> classReplacements = new HashMap<String, ClassReplacement>();

    public DowngradingTransformer(int sourceVersion, int targetVersion) {
        this.sourceVersion = sourceVersion;
        this.targetVersion = targetVersion;
        if (this.sourceVersion < this.targetVersion) {
            throw new IllegalArgumentException("Source version must be higher than target version");
        }
    }

    protected void addMethodCallReplacer(int opcode, String owner, String name, MethodCallReplacer replacer) {
        this.methodCallReplacers.put(owner + ';' + name, replacer);
    }

    protected void addMethodCallReplacer(int opcode, String owner, String name, String descriptor, MethodCallReplacer replacer) {
        this.methodCallReplacers.put(owner + ';' + name + descriptor, replacer);
    }

    protected void addClassReplacement(String name, ClassReplacement replacement) {
        this.classReplacements.put(name, replacement);
    }

    protected void addClassReplacement(String name) {
        this.addClassReplacement(name, ClassReplacement.ofRuntime(name));
    }

    protected void addClassReplacementWithExtraDeps(String name, String ... extraDeps) {
        this.addClassReplacement(name, ClassReplacement.ofRuntime(name, extraDeps));
    }

    public void transform(ClassNode classNode, DowngradeResult result) {
        this.transform(classNode, RuntimeDepCollector.NULL, result);
    }

    public void transform(ClassNode classNode, final RuntimeDepCollector depCollector, final DowngradeResult result) {
        if ((classNode.version & 0xFF) > this.sourceVersion) {
            throw new IllegalArgumentException("Input class version is higher than supported");
        }
        if ((classNode.version & 0xFF) <= this.targetVersion) {
            return;
        }
        this.preTransform(classNode, result);
        int bridge = 100;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.startsWith(BRIDGE_PREFIX)) continue;
            bridge = Integer.parseInt(methodNode.name.substring(BRIDGE_PREFIX.length())) + 1;
        }
        if (!this.methodCallReplacers.isEmpty()) {
            for (MethodNode methodNode : new ArrayList(classNode.methods)) {
                for (AbstractInsnNode abstractInsnNode : methodNode.instructions.toArray()) {
                    if (abstractInsnNode instanceof MethodInsnNode) {
                        MethodInsnNode methodInsn = (MethodInsnNode)abstractInsnNode;
                        MethodCallReplacer replacer = this.methodCallReplacers.get(methodInsn.owner + ';' + methodInsn.name + methodInsn.desc);
                        if (replacer == null) {
                            replacer = this.methodCallReplacers.get(methodInsn.owner + ';' + methodInsn.name);
                        }
                        if (replacer == null) continue;
                        methodNode.instructions.insertBefore((AbstractInsnNode)methodInsn, replacer.getReplacement(classNode, methodNode, methodInsn.name, methodInsn.desc, depCollector, result));
                        methodNode.instructions.remove((AbstractInsnNode)methodInsn);
                        result.incrementTransformerCount();
                        continue;
                    }
                    if (!(abstractInsnNode instanceof InvokeDynamicInsnNode)) continue;
                    InvokeDynamicInsnNode invokeDynamicInsn = (InvokeDynamicInsnNode)abstractInsnNode;
                    if (!invokeDynamicInsn.bsm.getOwner().equals("java/lang/invoke/LambdaMetafactory") || !invokeDynamicInsn.bsm.getName().equals("metafactory") || !invokeDynamicInsn.bsm.getDesc().equals("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;")) continue;
                    for (int i = 0; i < invokeDynamicInsn.bsmArgs.length; ++i) {
                        Object arg = invokeDynamicInsn.bsmArgs[i];
                        if (!(arg instanceof Handle)) continue;
                        Handle handle = (Handle)arg;
                        MethodCallReplacer replacer = this.methodCallReplacers.get(handle.getOwner() + ';' + handle.getName() + handle.getDesc());
                        if (replacer == null) {
                            replacer = this.methodCallReplacers.get(handle.getOwner() + ';' + handle.getName());
                        }
                        if (replacer == null) continue;
                        String desc = handle.getTag() == 6 || handle.getTag() == 2 || handle.getTag() == 4 ? handle.getDesc() : "(L" + handle.getOwner() + ';' + handle.getDesc().substring(1);
                        MethodNode bridgeMethod = new MethodNode(4106, BRIDGE_PREFIX + bridge++, desc, null, null);
                        Type[] argumentTypes = Type.getArgumentTypes((String)desc);
                        for (int i1 = 0; i1 < argumentTypes.length; ++i1) {
                            bridgeMethod.instructions.add((AbstractInsnNode)new VarInsnNode(argumentTypes[i1].getOpcode(21), i1));
                        }
                        bridgeMethod.instructions.add(replacer.getReplacement(classNode, bridgeMethod, handle.getName(), handle.getDesc(), depCollector, result));
                        bridgeMethod.instructions.add((AbstractInsnNode)new InsnNode(Type.getReturnType((String)handle.getDesc()).getOpcode(172)));
                        classNode.methods.add(bridgeMethod);
                        invokeDynamicInsn.bsmArgs[i] = new Handle(6, classNode.name, bridgeMethod.name, bridgeMethod.desc, (classNode.access & 0x200) != 0);
                        result.incrementTransformerCount();
                    }
                }
            }
        }
        if (!this.classReplacements.isEmpty()) {
            ClassNode remappedNode = new ClassNode();
            ClassRemapper classRemapper = new ClassRemapper((ClassVisitor)remappedNode, new Remapper(){

                public String map(String internalName) {
                    ClassReplacement replacement = (ClassReplacement)DowngradingTransformer.this.classReplacements.get(internalName);
                    if (replacement == null) {
                        return internalName;
                    }
                    result.setRequiresStackMapFrames();
                    if (replacement.includeDependency) {
                        depCollector.accept(replacement.newName);
                        replacement.extraDependencies.forEach(depCollector);
                    }
                    return replacement.newName;
                }
            });
            classNode.accept((ClassVisitor)classRemapper);
            for (Field field : ClassNode.class.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
                try {
                    field.set(classNode, field.get(remappedNode));
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to merge class nodes", t);
                }
            }
        }
        this.postTransform(classNode, result);
        classNode.version = this.targetVersion;
    }

    protected void preTransform(ClassNode classNode, DowngradeResult result) {
    }

    protected void postTransform(ClassNode classNode, DowngradeResult result) {
    }

    public int getSourceVersion() {
        return this.sourceVersion;
    }

    public int getTargetVersion() {
        return this.targetVersion;
    }

    protected static final class ClassReplacement {
        private final String newName;
        private final boolean includeDependency;
        private final List<String> extraDependencies;

        private ClassReplacement(String newName, boolean includeDependency, List<String> extraDependencies) {
            if (!includeDependency && !extraDependencies.isEmpty()) {
                throw new IllegalArgumentException("Cannot have extraDependencies if includeDependency is false!");
            }
            this.newName = newName;
            this.includeDependency = includeDependency;
            this.extraDependencies = extraDependencies;
        }

        public static ClassReplacement ofAbsolute(String newName) {
            return new ClassReplacement(newName, true, Collections.emptyList());
        }

        public static ClassReplacement ofRuntime(String newName) {
            return ClassReplacement.ofAbsolute("net/raphimc/javadowngrader/runtime/" + newName);
        }

        public static ClassReplacement ofAbsolute(String newName, String ... extraDependencies) {
            return new ClassReplacement(newName, true, Arrays.asList(extraDependencies));
        }

        public static ClassReplacement ofRuntime(String newName, String ... extraDependencies) {
            return new ClassReplacement("net/raphimc/javadowngrader/runtime/" + newName, true, Arrays.stream(extraDependencies).map(c -> "net/raphimc/javadowngrader/runtime/" + c).collect(Collectors.toList()));
        }

        public static ClassReplacement ofRenameOnly(String newName) {
            return new ClassReplacement(newName, false, Collections.emptyList());
        }
    }
}

