/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.javadowngrader;

import java.util.ArrayList;
import java.util.List;
import net.raphimc.javadowngrader.RuntimeDepCollector;
import net.raphimc.javadowngrader.transformer.DowngradeResult;
import net.raphimc.javadowngrader.transformer.DowngradingTransformer;
import net.raphimc.javadowngrader.transformer.j10.Java11ToJava10;
import net.raphimc.javadowngrader.transformer.j11.Java12ToJava11;
import net.raphimc.javadowngrader.transformer.j12.Java13ToJava12;
import net.raphimc.javadowngrader.transformer.j13.Java14ToJava13;
import net.raphimc.javadowngrader.transformer.j14.Java15ToJava14;
import net.raphimc.javadowngrader.transformer.j15.Java16ToJava15;
import net.raphimc.javadowngrader.transformer.j16.Java17ToJava16;
import net.raphimc.javadowngrader.transformer.j17.Java18ToJava17;
import net.raphimc.javadowngrader.transformer.j18.Java19ToJava18;
import net.raphimc.javadowngrader.transformer.j19.Java20ToJava19;
import net.raphimc.javadowngrader.transformer.j20.Java21ToJava20;
import net.raphimc.javadowngrader.transformer.j8.Java9ToJava8;
import net.raphimc.javadowngrader.transformer.j9.Java10ToJava9;
import org.objectweb.asm.tree.ClassNode;

public class JavaDowngrader {
    private static final List<DowngradingTransformer> TRANSFORMER = new ArrayList<DowngradingTransformer>();

    public static DowngradeResult downgrade(ClassNode classNode, int targetVersion) {
        return JavaDowngrader.downgrade(classNode, targetVersion, RuntimeDepCollector.NULL);
    }

    public static DowngradeResult downgrade(ClassNode classNode, int targetVersion, RuntimeDepCollector depCollector) {
        DowngradeResult result = new DowngradeResult();
        for (DowngradingTransformer transformer : TRANSFORMER) {
            if (transformer.getTargetVersion() < targetVersion || (classNode.version & 0xFF) <= transformer.getTargetVersion()) continue;
            transformer.transform(classNode, depCollector, result);
        }
        return result;
    }

    static {
        TRANSFORMER.add(new Java21ToJava20());
        TRANSFORMER.add(new Java20ToJava19());
        TRANSFORMER.add(new Java19ToJava18());
        TRANSFORMER.add(new Java18ToJava17());
        TRANSFORMER.add(new Java17ToJava16());
        TRANSFORMER.add(new Java16ToJava15());
        TRANSFORMER.add(new Java15ToJava14());
        TRANSFORMER.add(new Java14ToJava13());
        TRANSFORMER.add(new Java13ToJava12());
        TRANSFORMER.add(new Java12ToJava11());
        TRANSFORMER.add(new Java11ToJava10());
        TRANSFORMER.add(new Java10ToJava9());
        TRANSFORMER.add(new Java9ToJava8());
    }
}

