/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.valuemodifier;

import net.raphimc.audiomixer.valuemodifier.ValueModifier;

public abstract class SlidingValueModifier
implements ValueModifier {
    private final float durationMillis;
    private float elapsedMillis;
    private Runnable finishCallback;

    public SlidingValueModifier(float durationMillis) {
        if (durationMillis <= 0.0f) {
            throw new IllegalArgumentException("Duration must be greater than 0");
        }
        this.durationMillis = durationMillis;
    }

    @Override
    public float modify(float value, float referenceFrequency) {
        float progress = this.elapsedMillis / this.durationMillis;
        float modifiedValue = this.modify(value, referenceFrequency, progress);
        this.elapsedMillis += 1000.0f / referenceFrequency;
        if (this.elapsedMillis > this.durationMillis) {
            this.elapsedMillis = this.durationMillis;
        }
        if (this.finishCallback != null && progress == 1.0f) {
            this.finishCallback.run();
        }
        return modifiedValue;
    }

    protected abstract float modify(float var1, float var2, float var3);

    public void resetProgress() {
        this.elapsedMillis = 0.0f;
    }

    public float getDurationMillis() {
        return this.durationMillis;
    }

    public float getProgress() {
        return this.elapsedMillis / this.durationMillis;
    }

    public Runnable getFinishCallback() {
        return this.finishCallback;
    }

    public SlidingValueModifier setFinishCallback(Runnable finishCallback) {
        this.finishCallback = finishCallback;
        return this;
    }
}

