/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.util.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.raphimc.audiomixer.util.GrowableArray;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;
import net.raphimc.audiomixer.util.io.SampleInputStream;
import net.raphimc.audiomixer.util.io.SampleOutputStream;

public class SoundIO {
    public static float[] readSamples(InputStream is, PcmFloatAudioFormat targetAudioFormat) throws IOException, UnsupportedAudioFileException {
        return SoundIO.readSamples(new BufferedInputStream(is), targetAudioFormat);
    }

    public static float[] readSamples(BufferedInputStream is, PcmFloatAudioFormat targetAudioFormat) throws IOException, UnsupportedAudioFileException {
        return SoundIO.readSamples(AudioSystem.getAudioInputStream(is), targetAudioFormat);
    }

    public static float[] readSamples(AudioInputStream is, PcmFloatAudioFormat targetAudioFormat) throws IOException {
        float sample;
        SampleInputStream sis = new SampleInputStream(is, targetAudioFormat);
        GrowableArray samples = new GrowableArray(262144);
        while (!Float.isNaN(sample = sis.readSample())) {
            samples.add(sample);
        }
        sis.close();
        return samples.getArray();
    }

    public static void writeSamples(float[] samples, OutputStream os, AudioFormat targetAudioFormat) throws IOException {
        SampleOutputStream sos = new SampleOutputStream(os, targetAudioFormat);
        for (float sample : samples) {
            sos.writeSample(sample);
        }
        sos.close();
    }

    public static byte[] writeSamples(float[] samples, AudioFormat targetAudioFormat) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SoundIO.writeSamples(samples, baos, targetAudioFormat);
        return baos.toByteArray();
    }

    public static AudioInputStream createAudioInputStream(float[] samples, AudioFormat targetAudioFormat) throws IOException {
        return new AudioInputStream(new ByteArrayInputStream(SoundIO.writeSamples(samples, targetAudioFormat)), targetAudioFormat, samples.length);
    }
}

