/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;

public class SampleOutputStream
extends OutputStream {
    private final OutputStream os;
    private final InputStream is;
    private final byte[] writeBuffer;
    private final byte[] readBuffer;
    private int bufferIndex;

    public SampleOutputStream(OutputStream os, AudioFormat targetAudioFormat) {
        PcmFloatAudioFormat sourceAudioFormat = new PcmFloatAudioFormat(targetAudioFormat.getSampleRate(), targetAudioFormat.getChannels());
        AudioInputStream audioInputStream = new AudioInputStream(new BufferInputStream(), sourceAudioFormat, -1L);
        if (!sourceAudioFormat.matches(targetAudioFormat)) {
            audioInputStream = AudioSystem.getAudioInputStream(targetAudioFormat, audioInputStream);
        }
        this.os = os;
        this.is = audioInputStream;
        this.writeBuffer = new byte[sourceAudioFormat.getFrameSize()];
        this.readBuffer = new byte[targetAudioFormat.getFrameSize()];
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    public void writeSample(float sample) throws IOException {
        int intBits = Float.floatToIntBits(sample);
        this.writeBuffer[this.bufferIndex++] = (byte)(intBits >> 24 & 0xFF);
        this.writeBuffer[this.bufferIndex++] = (byte)(intBits >> 16 & 0xFF);
        this.writeBuffer[this.bufferIndex++] = (byte)(intBits >> 8 & 0xFF);
        this.writeBuffer[this.bufferIndex++] = (byte)(intBits & 0xFF);
        if (this.bufferIndex >= this.writeBuffer.length) {
            this.bufferIndex = 0;
            int actualReadBytes = this.is.readNBytes(this.readBuffer, 0, this.readBuffer.length);
            if (actualReadBytes != this.readBuffer.length) {
                throw new IOException("Failed to read from input stream, expected " + this.readBuffer.length + " bytes but got " + actualReadBytes);
            }
            this.bufferIndex = 0;
            this.os.write(this.readBuffer);
        }
    }

    private class BufferInputStream
    extends InputStream {
        private BufferInputStream() {
        }

        @Override
        public int read() {
            if (SampleOutputStream.this.bufferIndex < SampleOutputStream.this.writeBuffer.length) {
                return SampleOutputStream.this.writeBuffer[SampleOutputStream.this.bufferIndex++] & 0xFF;
            }
            return -1;
        }
    }
}

