/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.util.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;

public class SampleInputStream
extends InputStream {
    private final InputStream is;
    private final byte[] buffer;
    private int bufferIndex;
    private int bufferLength;

    public SampleInputStream(InputStream is, PcmFloatAudioFormat targetAudioFormat) throws UnsupportedAudioFileException, IOException {
        this(new BufferedInputStream(is), targetAudioFormat);
    }

    public SampleInputStream(BufferedInputStream is, PcmFloatAudioFormat targetAudioFormat) throws UnsupportedAudioFileException, IOException {
        this(AudioSystem.getAudioInputStream(is), targetAudioFormat);
    }

    public SampleInputStream(AudioInputStream is, PcmFloatAudioFormat targetAudioFormat) {
        AudioFormat sourceAudioFormat = is.getFormat();
        if (!sourceAudioFormat.matches(targetAudioFormat)) {
            is = AudioSystem.getAudioInputStream(targetAudioFormat, is);
        }
        this.is = is;
        this.buffer = new byte[targetAudioFormat.getFrameSize()];
    }

    @Override
    public int read() throws IOException {
        if (this.bufferIndex >= this.bufferLength) {
            this.bufferLength = this.is.readNBytes(this.buffer, 0, this.buffer.length);
            if (this.bufferLength == 0) {
                return -1;
            }
            this.bufferIndex = 0;
        }
        return this.buffer[this.bufferIndex++] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public float readSample() throws IOException {
        int b1 = this.read();
        int b2 = this.read();
        int b3 = this.read();
        int b4 = this.read();
        if (b1 == -1 || b2 == -1 || b3 == -1 || b4 == -1) {
            return Float.NaN;
        }
        return Float.intBitsToFloat(b1 << 24 | b2 << 16 | b3 << 8 | b4);
    }
}

