/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.util;

import java.util.Arrays;

public class SoundSampleUtil {
    public static void normalize(float[] samples) {
        SoundSampleUtil.normalize(samples, SoundSampleUtil.getMax(samples));
    }

    public static void normalize(float[] samples, float max) {
        if (max <= 1.0f) {
            return;
        }
        float factor = 1.0f / max;
        int i = 0;
        while (i < samples.length) {
            int n = i++;
            samples[n] = samples[n] * factor;
        }
    }

    public static void clip(float[] samples) {
        for (int i = 0; i < samples.length; ++i) {
            if (samples[i] > 1.0f) {
                samples[i] = 1.0f;
                continue;
            }
            if (!(samples[i] < -1.0f)) continue;
            samples[i] = -1.0f;
        }
    }

    public static float getMax(float[] samples) {
        float max = 0.0f;
        for (float sample : samples) {
            max = Math.max(max, Math.abs(sample));
        }
        return max;
    }

    public static float[] trimZeroesAtStart(float[] samples) {
        int i;
        for (i = 0; i < samples.length && samples[i] == 0.0f; ++i) {
        }
        return i == 0 ? samples : (i == samples.length ? new float[]{} : Arrays.copyOfRange(samples, i, samples.length));
    }

    public static float[] trimZeroesAtEnd(float[] samples) {
        int i;
        for (i = samples.length - 1; i >= 0 && samples[i] == 0.0f; --i) {
        }
        return i == samples.length - 1 ? samples : (i < 0 ? new float[]{} : Arrays.copyOf(samples, i + 1));
    }
}

