/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.util;

import java.util.Arrays;

public class GrowableArray {
    private float[] array;
    private int size;

    public GrowableArray(int initialSize) {
        this.array = new float[initialSize];
    }

    public void add(float value) {
        this.ensureHasEnoughSpace(1);
        this.array[this.size++] = value;
    }

    public void add(float[] value) {
        this.ensureHasEnoughSpace(value.length);
        System.arraycopy(value, 0, this.array, this.size, value.length);
        this.size += value.length;
    }

    public float[] getArrayDirect() {
        return this.array;
    }

    public float[] getArray() {
        return Arrays.copyOf(this.array, this.size);
    }

    private void ensureHasEnoughSpace(int bytes) {
        if (this.size + bytes <= this.array.length) {
            return;
        }
        int newSize = this.array.length + Math.max(bytes, this.array.length);
        this.array = Arrays.copyOf(this.array, newSize);
    }
}

