/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.soundmodifier.impl;

import net.raphimc.audiomixer.soundmodifier.SoundModifier;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;
import net.raphimc.audiomixer.valuemodifier.ValueModifier;

public class VolumeModifier
implements SoundModifier {
    private float volume;
    private ValueModifier volumeModifier;

    public VolumeModifier(float volume) {
        this.setVolume(volume);
    }

    @Override
    public void modify(PcmFloatAudioFormat audioFormat, float[] renderedSamples) {
        boolean hasVolumeModifier = this.volumeModifier != null;
        for (int i = 0; i < renderedSamples.length; ++i) {
            float volume = !hasVolumeModifier ? this.volume : Math.min(Math.max(this.volumeModifier.modify(this.volume, audioFormat.getSampleRate()), 0.0f), 1.0f);
            renderedSamples[i] = renderedSamples[i] * volume;
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public VolumeModifier setVolume(float volume) {
        if (volume < 0.0f || volume > 1.0f) {
            throw new IllegalArgumentException("Volume must be between 0 and 1");
        }
        this.volume = volume;
        return this;
    }

    public ValueModifier getVolumeModifier() {
        return this.volumeModifier;
    }

    public VolumeModifier setVolumeModifier(ValueModifier volumeModifier) {
        this.volumeModifier = volumeModifier;
        return this;
    }
}

