/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.soundmodifier.impl;

import net.raphimc.audiomixer.soundmodifier.SoundModifier;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;

public class SpatialModifier
implements SoundModifier {
    private float maxDistance;
    private float soundX;
    private float soundY;
    private float soundZ;
    private float listenerX;
    private float listenerY;
    private float listenerZ;
    private float listenerYaw;
    private boolean recalculate = true;
    private float panning;
    private float attenuation;

    public SpatialModifier(float maxDistance) {
        this.setMaxDistance(maxDistance);
    }

    @Override
    public void modify(PcmFloatAudioFormat audioFormat, float[] renderedSamples) {
        if (audioFormat.getChannels() != 2) {
            throw new UnsupportedOperationException("Target audio format must have 2 channels");
        }
        if (this.recalculate) {
            this.recalculate = false;
            this.calculatePanningAndAttenuation();
        }
        for (int i = 0; i < renderedSamples.length; i += 2) {
            renderedSamples[i] = renderedSamples[i] * (1.0f - this.panning) * this.attenuation;
            renderedSamples[i + 1] = renderedSamples[i + 1] * this.panning * this.attenuation;
        }
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public SpatialModifier setMaxDistance(float maxDistance) {
        if (maxDistance <= 0.0f) {
            throw new IllegalArgumentException("Max distance must be greater than zero");
        }
        this.maxDistance = maxDistance;
        this.recalculate = true;
        return this;
    }

    public float getSoundX() {
        return this.soundX;
    }

    public SpatialModifier setSoundX(float soundX) {
        this.soundX = soundX;
        this.recalculate = true;
        return this;
    }

    public float getSoundY() {
        return this.soundY;
    }

    public SpatialModifier setSoundY(float soundY) {
        this.soundY = soundY;
        this.recalculate = true;
        return this;
    }

    public float getSoundZ() {
        return this.soundZ;
    }

    public SpatialModifier setSoundZ(float soundZ) {
        this.soundZ = soundZ;
        this.recalculate = true;
        return this;
    }

    public float getListenerX() {
        return this.listenerX;
    }

    public SpatialModifier setListenerX(float listenerX) {
        this.listenerX = listenerX;
        this.recalculate = true;
        return this;
    }

    public float getListenerY() {
        return this.listenerY;
    }

    public SpatialModifier setListenerY(float listenerY) {
        this.listenerY = listenerY;
        this.recalculate = true;
        return this;
    }

    public float getListenerZ() {
        return this.listenerZ;
    }

    public SpatialModifier setListenerZ(float listenerZ) {
        this.listenerZ = listenerZ;
        this.recalculate = true;
        return this;
    }

    public float getListenerYaw() {
        return this.listenerYaw;
    }

    public SpatialModifier setListenerYaw(float listenerYaw) {
        this.listenerYaw = listenerYaw;
        this.recalculate = true;
        return this;
    }

    public float getListenerYawDegrees() {
        return (float)Math.toDegrees(this.listenerYaw);
    }

    public SpatialModifier setListenerYawDegrees(int listenerYaw) {
        return this.setListenerYaw((float)Math.toRadians(listenerYaw % 360));
    }

    private void calculatePanningAndAttenuation() {
        float deltaX = this.soundX - this.listenerX;
        float deltaY = this.soundY - this.listenerY;
        float deltaZ = this.soundZ - this.listenerZ;
        float distance = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        if (distance >= this.maxDistance) {
            this.panning = 0.5f;
            this.attenuation = 0.0f;
            return;
        }
        this.attenuation = 1.0f - distance / this.maxDistance;
        float angleToSound = (float)Math.atan2(deltaX, -deltaZ);
        float relativeAngle = (float)(((double)(angleToSound - this.listenerYaw) + Math.PI) % (Math.PI * 2) - Math.PI);
        this.panning = ((float)Math.sin(relativeAngle) + 1.0f) / 2.0f;
    }
}

