/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.soundmodifier.impl;

import net.raphimc.audiomixer.soundmodifier.SoundModifier;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;

public class PanningModifier
implements SoundModifier {
    private float panning;

    public PanningModifier(float panning) {
        this.setPanning(panning);
    }

    @Override
    public void modify(PcmFloatAudioFormat audioFormat, float[] renderedSamples) {
        if (audioFormat.getChannels() != 2) {
            throw new UnsupportedOperationException("Target audio format must have 2 channels");
        }
        for (int i = 0; i < renderedSamples.length; i += 2) {
            renderedSamples[i] = renderedSamples[i] * (1.0f - this.panning);
            renderedSamples[i + 1] = renderedSamples[i + 1] * this.panning;
        }
    }

    public float getPanning() {
        return this.panning * 2.0f - 1.0f;
    }

    public PanningModifier setPanning(float panning) {
        this.panning = (Math.max(-1.0f, Math.min(1.0f, panning)) + 1.0f) / 2.0f;
        return this;
    }
}

