/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.soundmodifier.impl;

import net.raphimc.audiomixer.soundmodifier.SoundModifier;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;
import net.raphimc.audiomixer.util.SoundSampleUtil;

public class NormalizationModifier
implements SoundModifier {
    private int decayPeriodMillis;
    private float runningMaxSampleValue = 0.0f;

    public NormalizationModifier() {
        this(3000);
    }

    public NormalizationModifier(int decayPeriodMillis) {
        this.setDecayPeriodMillis(decayPeriodMillis);
    }

    @Override
    public void modify(PcmFloatAudioFormat audioFormat, float[] renderedSamples) {
        float timeElapsedMillis = (float)renderedSamples.length / (float)audioFormat.getChannels() * 1000.0f / audioFormat.getSampleRate();
        float decayFactor = (float)Math.exp(-timeElapsedMillis / (float)this.decayPeriodMillis);
        this.runningMaxSampleValue *= decayFactor;
        float max = SoundSampleUtil.getMax(renderedSamples);
        if (max > this.runningMaxSampleValue) {
            this.runningMaxSampleValue = max;
        }
        SoundSampleUtil.normalize(renderedSamples, this.runningMaxSampleValue);
    }

    public void reset() {
        this.runningMaxSampleValue = 0.0f;
    }

    public int getDecayPeriodMillis() {
        return this.decayPeriodMillis;
    }

    public NormalizationModifier setDecayPeriodMillis(int decayPeriodMillis) {
        this.decayPeriodMillis = decayPeriodMillis;
        return this;
    }
}

