/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.soundmodifier.impl;

import java.util.Arrays;
import net.raphimc.audiomixer.soundmodifier.SoundModifier;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;

public class BitCrushModifier
implements SoundModifier {
    private int decimationRate;
    private int counter;
    private float[] lastSample = new float[2];

    public BitCrushModifier() {
        this(15);
    }

    public BitCrushModifier(int decimationRate) {
        this.setDecimationRate(decimationRate);
    }

    @Override
    public void modify(PcmFloatAudioFormat audioFormat, float[] renderedSamples) {
        int channels = audioFormat.getChannels();
        if (this.lastSample.length < channels) {
            this.lastSample = Arrays.copyOf(this.lastSample, channels);
        }
        for (int i = 0; i < renderedSamples.length; i += channels) {
            if (this.counter == 0) {
                this.counter = this.decimationRate;
                for (int channelIndex = 0; channelIndex < channels; ++channelIndex) {
                    int intSample = (int)(renderedSamples[i + channelIndex] * 32767.0f);
                    this.lastSample[channelIndex] = (float)(intSample & 0xFFFFFFFC) / 32767.0f;
                }
            } else {
                --this.counter;
            }
            System.arraycopy(this.lastSample, 0, renderedSamples, i, channels);
        }
    }

    public int getDecimationRate() {
        return this.decimationRate;
    }

    public BitCrushModifier setDecimationRate(int decimationRate) {
        if (decimationRate <= 0) {
            throw new IllegalArgumentException("Decimation rate must be greater than 0");
        }
        this.decimationRate = decimationRate;
        return this;
    }
}

