/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.soundmodifier.impl;

import java.util.Arrays;
import net.raphimc.audiomixer.soundmodifier.SoundModifier;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;

public class BassBoostModifier
implements SoundModifier {
    private float factor;
    private float rc;
    private float[] previousResult = new float[2];

    public BassBoostModifier(float cutoffFrequency) {
        this(cutoffFrequency, 1.0f);
    }

    public BassBoostModifier(float cutoffFrequency, float factor) {
        this.setCutoffFrequency(cutoffFrequency);
        this.setFactor(factor);
    }

    @Override
    public void modify(PcmFloatAudioFormat audioFormat, float[] renderedSamples) {
        int channels = audioFormat.getChannels();
        if (this.previousResult.length < channels) {
            this.previousResult = Arrays.copyOf(this.previousResult, channels);
        }
        float dt = 1.0f / audioFormat.getSampleRate();
        float alpha = dt / (this.rc + dt);
        for (int i = 0; i < renderedSamples.length; ++i) {
            float result;
            int channelIndex = i % channels;
            float sample = renderedSamples[i];
            this.previousResult[channelIndex] = result = (1.0f - alpha) * this.previousResult[channelIndex] + alpha * sample;
            renderedSamples[i] = sample + result * this.factor;
        }
    }

    public BassBoostModifier setCutoffFrequency(float cutoffFrequency) {
        this.rc = (float)(1.0 / (Math.PI * 2 * (double)cutoffFrequency));
        return this;
    }

    public float getFactor() {
        return this.factor;
    }

    public BassBoostModifier setFactor(float factor) {
        if (factor < 0.0f) {
            throw new IllegalArgumentException("Factor must be greater than or equal to 0");
        }
        this.factor = factor;
        return this;
    }
}

