/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.soundmodifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.raphimc.audiomixer.soundmodifier.SoundModifier;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;

public class SoundModifiers
implements SoundModifier {
    protected final List<SoundModifier> soundModifiers = new ArrayList<SoundModifier>();

    public SoundModifiers() {
    }

    public SoundModifiers(SoundModifier ... modifiers) {
        this.soundModifiers.addAll(Arrays.asList(modifiers));
    }

    @Override
    public synchronized void modify(PcmFloatAudioFormat audioFormat, float[] renderedSamples) {
        if (this.soundModifiers.isEmpty()) {
            return;
        }
        for (SoundModifier modifier : this.soundModifiers) {
            modifier.modify(audioFormat, renderedSamples);
        }
    }

    public synchronized List<SoundModifier> get(Predicate<SoundModifier> predicate) {
        return this.soundModifiers.stream().filter(predicate).toList();
    }

    public synchronized SoundModifier getFirst(Predicate<SoundModifier> predicate) {
        return this.soundModifiers.stream().filter(predicate).findFirst().orElse(null);
    }

    public synchronized <T extends SoundModifier> T getFirst(Class<T> clazz) {
        return (T)((SoundModifier)this.soundModifiers.stream().filter(m -> m.getClass().equals(clazz)).map(clazz::cast).findFirst().orElse(null));
    }

    public synchronized void append(SoundModifier soundModifier) {
        this.soundModifiers.add(soundModifier);
    }

    public synchronized void prepend(SoundModifier soundModifier) {
        this.soundModifiers.add(0, soundModifier);
    }

    public synchronized boolean insertBefore(SoundModifier soundModifier, SoundModifier other) {
        int index = this.soundModifiers.indexOf(other);
        if (index != -1) {
            this.soundModifiers.add(index, soundModifier);
            return true;
        }
        return false;
    }

    public synchronized boolean insertAfter(SoundModifier soundModifier, SoundModifier other) {
        int index = this.soundModifiers.indexOf(other);
        if (index != -1) {
            this.soundModifiers.add(index + 1, soundModifier);
            return true;
        }
        return false;
    }

    public synchronized void remove(SoundModifier soundModifier) {
        this.soundModifiers.remove(soundModifier);
    }

    public synchronized void clear() {
        this.soundModifiers.clear();
    }

    public synchronized boolean isEmpty() {
        return this.soundModifiers.isEmpty();
    }
}

