/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.sound.impl.pcm;

import java.util.Arrays;
import net.raphimc.audiomixer.pcmsource.StereoPcmSource;
import net.raphimc.audiomixer.sound.Sound;
import net.raphimc.audiomixer.util.ArrayUtil;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;
import net.raphimc.audiomixer.valuemodifier.ValueModifier;

public class StereoSound
extends Sound {
    private final StereoPcmSource pcmSource;
    private float pitch;
    private ValueModifier pitchModifier;

    public StereoSound(StereoPcmSource pcmSource) {
        this(pcmSource, 1.0f);
    }

    public StereoSound(StereoPcmSource pcmSource, float pitch) {
        this.pcmSource = pcmSource;
        this.setPitch(pitch);
    }

    @Override
    public void render(PcmFloatAudioFormat audioFormat, float[] renderedSamples) {
        int renderedIndex = 0;
        if (this.pitch == 1.0f && audioFormat.getChannels() == 2 && this.pitchModifier == null) {
            renderedIndex += this.pcmSource.consumeSamples(renderedSamples);
        } else {
            int numChannels = audioFormat.getChannels();
            int numSamples = renderedSamples.length / numChannels;
            boolean hasPitchModifier = this.pitchModifier != null;
            for (int i = 0; i < numSamples && !this.isFinished(); ++i) {
                float pitch = !hasPitchModifier ? this.pitch : Math.max(this.pitchModifier.modify(this.pitch, audioFormat.getSampleRate()), 0.0f);
                float[] sample = this.pcmSource.consumeSample(pitch);
                if (numChannels == 2) {
                    renderedSamples[renderedIndex++] = sample[0];
                    renderedSamples[renderedIndex++] = sample[1];
                    continue;
                }
                float monoSample = (sample[0] + sample[1]) / 2.0f;
                ArrayUtil.fillFast(renderedSamples, renderedIndex, numChannels, monoSample);
                renderedIndex += numChannels;
            }
        }
        Arrays.fill(renderedSamples, renderedIndex, renderedSamples.length, 0.0f);
        this.soundModifiers.modify(audioFormat, renderedSamples);
    }

    @Override
    public boolean isFinished() {
        return this.pcmSource.hasReachedEnd();
    }

    public StereoPcmSource getPcmSource() {
        return this.pcmSource;
    }

    public float getPitch() {
        return this.pitch;
    }

    public StereoSound setPitch(float pitch) {
        if (pitch < 0.0f) {
            throw new IllegalArgumentException("Pitch must be greater than or equal to 0");
        }
        this.pitch = pitch;
        return this;
    }

    public ValueModifier getPitchModifier() {
        return this.pitchModifier;
    }

    public StereoSound setPitchModifier(ValueModifier pitchModifier) {
        this.pitchModifier = pitchModifier;
        return this;
    }
}

