/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.sound.impl.pcm;

import java.util.Arrays;
import net.raphimc.audiomixer.pcmsource.MonoPcmSource;
import net.raphimc.audiomixer.sound.Sound;
import net.raphimc.audiomixer.util.ArrayUtil;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;

public class OptimizedMonoSound
extends Sound {
    private final MonoPcmSource pcmSource;
    private float pitch;
    private float volume;
    private float panning;

    public OptimizedMonoSound(MonoPcmSource pcmSource) {
        this(pcmSource, 1.0f, 1.0f, 0.0f);
    }

    public OptimizedMonoSound(MonoPcmSource pcmSource, float pitch, float volume, float panning) {
        this.pcmSource = pcmSource;
        this.setPitch(pitch);
        this.setVolume(volume);
        this.setPanning(panning);
    }

    @Override
    public void render(PcmFloatAudioFormat audioFormat, float[] renderedSamples) {
        int numChannels = audioFormat.getChannels();
        int numSamples = renderedSamples.length / numChannels;
        float leftVolume = numChannels == 2 ? (1.0f - this.panning) * this.volume : 0.0f;
        float rightVolume = numChannels == 2 ? this.panning * this.volume : 0.0f;
        int renderedIndex = 0;
        for (int i = 0; i < numSamples && !this.isFinished(); ++i) {
            float sample = this.pcmSource.consumeSample(this.pitch);
            if (numChannels == 2) {
                renderedSamples[renderedIndex++] = sample * leftVolume;
                renderedSamples[renderedIndex++] = sample * rightVolume;
                continue;
            }
            ArrayUtil.fillFast(renderedSamples, renderedIndex, numChannels, sample * this.volume);
            renderedIndex += numChannels;
        }
        Arrays.fill(renderedSamples, renderedIndex, renderedSamples.length, 0.0f);
        this.soundModifiers.modify(audioFormat, renderedSamples);
    }

    @Override
    public boolean isFinished() {
        return this.pcmSource.hasReachedEnd();
    }

    public MonoPcmSource getPcmSource() {
        return this.pcmSource;
    }

    public float getPitch() {
        return this.pitch;
    }

    public OptimizedMonoSound setPitch(float pitch) {
        if (pitch <= 0.0f) {
            throw new IllegalArgumentException("Pitch must be greater than 0");
        }
        this.pitch = pitch;
        return this;
    }

    public float getVolume() {
        return this.volume;
    }

    public OptimizedMonoSound setVolume(float volume) {
        this.volume = Math.max(0.0f, volume);
        return this;
    }

    public float getPanning() {
        return this.panning * 2.0f - 1.0f;
    }

    public OptimizedMonoSound setPanning(float panning) {
        this.panning = (Math.max(-1.0f, Math.min(1.0f, panning)) + 1.0f) / 2.0f;
        return this;
    }
}

