/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.sound.impl;

import java.util.ArrayList;
import java.util.List;
import net.raphimc.audiomixer.sound.Sound;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;

public class SubMixSound
extends Sound {
    protected final List<Sound> sounds = new ArrayList<Sound>();
    private int maxSounds;
    private int mixedSounds;
    private long mixRenderTime;

    public SubMixSound() {
        this(512);
    }

    public SubMixSound(int maxSounds) {
        this.setMaxSounds(maxSounds);
    }

    @Override
    public synchronized void render(PcmFloatAudioFormat audioFormat, float[] finalMixBuffer) {
        long start = System.nanoTime();
        this.mixedSounds = this.sounds.size();
        float[] renderedSamples = new float[finalMixBuffer.length];
        for (Sound sound : this.sounds) {
            sound.render(audioFormat, renderedSamples);
            for (int i = 0; i < finalMixBuffer.length; ++i) {
                int n = i;
                finalMixBuffer[n] = finalMixBuffer[n] + renderedSamples[i];
            }
        }
        this.soundModifiers.modify(audioFormat, finalMixBuffer);
        this.sounds.removeIf(Sound::isFinished);
        this.mixRenderTime = System.nanoTime() - start;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    public synchronized void playSound(Sound sound) {
        if (this.sounds.size() >= this.maxSounds) {
            this.sounds.remove(0);
        }
        this.sounds.add(sound);
    }

    public synchronized void stopSound(Sound sound) {
        this.sounds.remove(sound);
    }

    public synchronized void stopAllSounds() {
        this.sounds.clear();
    }

    public int getMaxSounds() {
        return this.maxSounds;
    }

    public SubMixSound setMaxSounds(int maxSounds) {
        if (maxSounds < 1) {
            throw new IllegalArgumentException("Max sounds must be at least 1");
        }
        this.maxSounds = maxSounds;
        return this;
    }

    public int getMixedSounds() {
        return this.mixedSounds;
    }

    public long getMixRenderTime() {
        return this.mixRenderTime;
    }

    public synchronized int getActiveSounds() {
        return this.sounds.size();
    }
}

