/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.sound.impl;

import net.raphimc.audiomixer.oscillator.Oscillator;
import net.raphimc.audiomixer.sound.Sound;
import net.raphimc.audiomixer.util.PcmFloatAudioFormat;

public class OscillatorSound
extends Sound {
    private final Oscillator oscillator;

    public OscillatorSound(Oscillator oscillator) {
        this.oscillator = oscillator;
    }

    @Override
    public void render(PcmFloatAudioFormat audioFormat, float[] renderedSamples) {
        int numChannels = audioFormat.getChannels();
        float sampleRate = audioFormat.getSampleRate();
        for (int i = 0; i < renderedSamples.length; i += numChannels) {
            float sample = this.oscillator.getNextValue(sampleRate);
            for (int channel = 0; channel < numChannels; ++channel) {
                renderedSamples[i + channel] = sample;
            }
        }
        this.soundModifiers.modify(audioFormat, renderedSamples);
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    public Oscillator getOscillator() {
        return this.oscillator;
    }
}

