/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.pcmsource.impl;

import net.raphimc.audiomixer.interpolator.Interpolator;
import net.raphimc.audiomixer.interpolator.impl.LinearInterpolator;
import net.raphimc.audiomixer.pcmsource.StaticPcmSource;
import net.raphimc.audiomixer.pcmsource.StereoPcmSource;

public class StereoStaticPcmSource
implements StereoPcmSource,
StaticPcmSource {
    private final float[] samples;
    private final int sampleCount;
    private final float[] buffer = new float[2];
    private final Interpolator interpolator;
    private double position;

    public StereoStaticPcmSource(float[] samples) {
        this(samples, LinearInterpolator.INSTANCE);
    }

    public StereoStaticPcmSource(float[] samples, Interpolator interpolator) {
        if (samples == null || samples.length == 0) {
            throw new IllegalArgumentException("Samples must not be null or empty");
        }
        if (samples.length % 2 != 0) {
            throw new IllegalArgumentException("Sample count must be a multiple of 2");
        }
        this.samples = samples;
        this.sampleCount = samples.length / 2;
        this.interpolator = interpolator;
    }

    @Override
    public float[] consumeSample(float increment) {
        this.buffer[0] = this.interpolator.interpolate(this.samples, this.position, 0, 2);
        this.buffer[1] = this.interpolator.interpolate(this.samples, this.position, 1, 2);
        this.position += (double)increment;
        return this.buffer;
    }

    @Override
    public int consumeSamples(float[] buffer, int offset, int length) {
        int numSamples = Math.min(length / 2, this.sampleCount - (int)this.position);
        System.arraycopy(this.samples, (int)this.position * 2, buffer, offset * 2, numSamples * 2);
        this.position += (double)numSamples;
        return numSamples * 2;
    }

    @Override
    public boolean hasReachedEnd() {
        return (int)this.position >= this.sampleCount;
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public double getPosition() {
        return this.position;
    }

    @Override
    public StaticPcmSource setPosition(double position) {
        this.position = position;
        return this;
    }

    @Override
    public float getProgress() {
        return (float)(this.position / (double)this.sampleCount);
    }

    @Override
    public StaticPcmSource setProgress(float progress) {
        this.position = (int)((double)progress * (double)this.sampleCount);
        return this;
    }
}

