/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.pcmsource.impl;

import java.util.ArrayList;
import java.util.List;
import net.raphimc.audiomixer.interpolator.Interpolator;
import net.raphimc.audiomixer.interpolator.impl.LinearInterpolator;
import net.raphimc.audiomixer.pcmsource.StereoPcmSource;

public class StereoPushPcmSource
implements StereoPcmSource {
    private final List<float[]> samplesQueue = new ArrayList<float[]>();
    private final float[] buffer = new float[2];
    private final Interpolator interpolator;
    private double position;

    public StereoPushPcmSource() {
        this(LinearInterpolator.INSTANCE);
    }

    public StereoPushPcmSource(Interpolator interpolator) {
        if (interpolator == null) {
            throw new IllegalArgumentException("Interpolator must not be null");
        }
        this.interpolator = interpolator;
    }

    @Override
    public synchronized float[] consumeSample(float increment) {
        if (this.samplesQueue.isEmpty()) {
            this.buffer[0] = 0.0f;
            this.buffer[1] = 0.0f;
            return this.buffer;
        }
        float[] samples = this.samplesQueue.get(0);
        if ((int)this.position * 2 >= samples.length) {
            this.samplesQueue.remove(0);
            this.position = 0.0;
            return this.consumeSample(increment);
        }
        this.buffer[0] = this.interpolator.interpolate(samples, this.position, 0, 2);
        this.buffer[1] = this.interpolator.interpolate(samples, this.position, 1, 2);
        this.position += (double)increment;
        return this.buffer;
    }

    @Override
    public boolean hasReachedEnd() {
        return false;
    }

    public synchronized void enqueueSamples(float[] samples) {
        if (samples == null || samples.length == 0) {
            throw new IllegalArgumentException("Samples must not be null or empty");
        }
        if (samples.length % 2 != 0) {
            throw new IllegalArgumentException("Sample count must be a multiple of 2");
        }
        this.samplesQueue.add(samples);
    }

    public synchronized void flushQueue() {
        this.samplesQueue.clear();
        this.position = 0.0;
    }

    public synchronized int getQueuedBufferCount() {
        return this.samplesQueue.size();
    }

    public synchronized int getQueuedSampleCount() {
        int total = -((int)this.position) * 2;
        for (float[] samples : this.samplesQueue) {
            total += samples.length;
        }
        return total / 2;
    }
}

