/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.pcmsource.impl;

import net.raphimc.audiomixer.interpolator.Interpolator;
import net.raphimc.audiomixer.interpolator.impl.LinearInterpolator;
import net.raphimc.audiomixer.pcmsource.MonoPcmSource;
import net.raphimc.audiomixer.pcmsource.StaticPcmSource;

public class MonoStaticPcmSource
implements MonoPcmSource,
StaticPcmSource {
    private final float[] samples;
    private final Interpolator interpolator;
    private double position;

    public MonoStaticPcmSource(float[] samples) {
        this(samples, LinearInterpolator.INSTANCE);
    }

    public MonoStaticPcmSource(float[] samples, Interpolator interpolator) {
        if (samples == null || samples.length == 0) {
            throw new IllegalArgumentException("Samples must not be null or empty");
        }
        if (interpolator == null) {
            throw new IllegalArgumentException("Interpolator must not be null");
        }
        this.samples = samples;
        this.interpolator = interpolator;
    }

    @Override
    public float consumeSample(float increment) {
        float sample = this.interpolator.interpolate(this.samples, this.position, 0, 1);
        this.position += (double)increment;
        return sample;
    }

    @Override
    public int consumeSamples(float[] buffer, int offset, int length) {
        int numSamples = Math.min(length, this.samples.length - (int)this.position);
        System.arraycopy(this.samples, (int)this.position, buffer, offset, numSamples);
        this.position += (double)numSamples;
        return numSamples;
    }

    @Override
    public boolean hasReachedEnd() {
        return (int)this.position >= this.samples.length;
    }

    @Override
    public int getSampleCount() {
        return this.samples.length;
    }

    @Override
    public double getPosition() {
        return this.position;
    }

    @Override
    public StaticPcmSource setPosition(double position) {
        this.position = position;
        return this;
    }

    @Override
    public float getProgress() {
        return (float)(this.position / (double)this.samples.length);
    }

    @Override
    public StaticPcmSource setProgress(float progress) {
        this.position = (int)((double)progress * (double)this.samples.length);
        return this;
    }
}

