/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.pcmsource.impl;

import java.util.ArrayList;
import java.util.List;
import net.raphimc.audiomixer.interpolator.Interpolator;
import net.raphimc.audiomixer.interpolator.impl.LinearInterpolator;
import net.raphimc.audiomixer.pcmsource.MonoPcmSource;

public class MonoPushPcmSource
implements MonoPcmSource {
    private final List<float[]> samplesQueue = new ArrayList<float[]>();
    private final Interpolator interpolator;
    private double position;

    public MonoPushPcmSource() {
        this(LinearInterpolator.INSTANCE);
    }

    public MonoPushPcmSource(Interpolator interpolator) {
        if (interpolator == null) {
            throw new IllegalArgumentException("Interpolator must not be null");
        }
        this.interpolator = interpolator;
    }

    @Override
    public synchronized float consumeSample(float increment) {
        if (this.samplesQueue.isEmpty()) {
            return 0.0f;
        }
        float[] samples = this.samplesQueue.get(0);
        if ((int)this.position >= samples.length) {
            this.samplesQueue.remove(0);
            this.position = 0.0;
            return this.consumeSample(increment);
        }
        float sample = this.interpolator.interpolate(samples, this.position, 0, 1);
        this.position += (double)increment;
        return sample;
    }

    @Override
    public boolean hasReachedEnd() {
        return false;
    }

    public synchronized void enqueueSamples(float[] samples) {
        if (samples == null || samples.length == 0) {
            throw new IllegalArgumentException("Samples must not be null or empty");
        }
        this.samplesQueue.add(samples);
    }

    public synchronized void flushQueue() {
        this.samplesQueue.clear();
        this.position = 0.0;
    }

    public synchronized int getQueuedBufferCount() {
        return this.samplesQueue.size();
    }

    public synchronized int getQueuedSampleCount() {
        int total = -((int)this.position);
        for (float[] samples : this.samplesQueue) {
            total += samples.length;
        }
        return total;
    }
}

