/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.pcmsource.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import net.raphimc.audiomixer.interpolator.Interpolator;
import net.raphimc.audiomixer.interpolator.impl.LinearInterpolator;
import net.raphimc.audiomixer.pcmsource.impl.MonoPushPcmSource;
import net.raphimc.audiomixer.util.io.SampleInputStream;

public class MonoPullPcmSource
extends MonoPushPcmSource
implements Closeable {
    private final SampleInputStream sampleInputStream;
    private final int bufferSize;
    private final Thread readThread;
    private volatile boolean reachedEnd;

    public MonoPullPcmSource(SampleInputStream sampleInputStream) {
        this(sampleInputStream, 262144);
    }

    public MonoPullPcmSource(SampleInputStream sampleInputStream, int bufferSize) {
        this(sampleInputStream, bufferSize, LinearInterpolator.INSTANCE);
    }

    public MonoPullPcmSource(SampleInputStream sampleInputStream, int bufferSize, Interpolator interpolator) {
        super(interpolator);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        this.sampleInputStream = sampleInputStream;
        this.bufferSize = bufferSize;
        this.readThread = new Thread(() -> {
            try {
                while (!this.reachedEnd) {
                    while (!this.reachedEnd && this.getQueuedSampleCount() < this.bufferSize) {
                        float[] buffer = new float[]{};
                        int bufferLen = 0;
                        try {
                            buffer = new float[this.bufferSize];
                            for (bufferLen = 0; bufferLen < buffer.length; ++bufferLen) {
                                float sample = this.sampleInputStream.readSample();
                                if (Float.isNaN(sample)) {
                                    this.reachedEnd = true;
                                    break;
                                }
                                buffer[bufferLen] = sample;
                            }
                        }
                        catch (IOException ignored) {
                            this.reachedEnd = true;
                        }
                        if (bufferLen <= 0) continue;
                        if (buffer.length != bufferLen) {
                            this.enqueueSamples(Arrays.copyOf(buffer, bufferLen));
                            continue;
                        }
                        this.enqueueSamples(buffer);
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Throwable e) {
                if (e.getCause() instanceof InterruptedException) {
                    return;
                }
                e.printStackTrace();
                this.reachedEnd = true;
            }
        }, "MonoPullPcmSource-ReadThread");
        this.readThread.setDaemon(true);
        this.readThread.start();
    }

    @Override
    public boolean hasReachedEnd() {
        return this.reachedEnd && this.getQueuedSampleCount() == 0;
    }

    @Override
    public void close() throws IOException {
        this.reachedEnd = true;
        this.readThread.interrupt();
        this.sampleInputStream.close();
    }
}

