/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.oscillator.impl;

import net.raphimc.audiomixer.oscillator.Oscillator;

public class SquareOscillator
extends Oscillator {
    private float dutyCycle;

    public SquareOscillator(float frequency) {
        this(frequency, 0.5f);
    }

    public SquareOscillator(float frequency, float dutyCycle) {
        super(frequency);
        this.setDutyCycle(dutyCycle);
    }

    @Override
    protected float computeNextValue() {
        return this.angle < (double)this.dutyCycle * (Math.PI * 2) ? 1.0f : -1.0f;
    }

    public float getDutyCycle() {
        return this.dutyCycle;
    }

    public SquareOscillator setDutyCycle(float dutyCycle) {
        if (dutyCycle <= 0.0f || dutyCycle >= 1.0f) {
            throw new IllegalArgumentException("Duty cycle must be between 0 and 1 (exclusive)");
        }
        this.dutyCycle = dutyCycle;
        return this;
    }
}

