/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.oscillator;

import net.raphimc.audiomixer.modulator.Modulator;
import net.raphimc.audiomixer.valuemodifier.ValueModifier;

public abstract class Oscillator
extends Modulator {
    protected static final double TWO_PI = Math.PI * 2;
    private float frequency;
    private ValueModifier frequencyModifier;
    protected double angle;

    public Oscillator() {
    }

    public Oscillator(float frequency) {
        this.setFrequency(frequency);
    }

    @Override
    protected float getNextNormalizedValue(float referenceFrequency) {
        float value = this.computeNextValue();
        this.angle = this.frequencyModifier == null ? (this.angle += Math.PI * 2 * (double)(this.frequency / referenceFrequency)) : (this.angle += Math.PI * 2 * (double)(Math.max(this.frequencyModifier.modify(this.frequency, referenceFrequency), 0.0f) / referenceFrequency));
        if (this.angle > Math.PI * 2) {
            this.angle -= Math.PI * 2;
        }
        return value;
    }

    protected abstract float computeNextValue();

    public float getFrequency() {
        return this.frequency;
    }

    public Oscillator setFrequency(float frequency) {
        if (frequency < 0.0f) {
            throw new IllegalArgumentException("Frequency must be greater than or equal to 0");
        }
        this.frequency = frequency;
        return this;
    }

    public ValueModifier getFrequencyModifier() {
        return this.frequencyModifier;
    }

    public Oscillator setFrequencyModifier(ValueModifier frequencyModifier) {
        this.frequencyModifier = frequencyModifier;
        return this;
    }
}

