/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.audiomixer.modulator;

import net.raphimc.audiomixer.valuemodifier.ValueModifier;

public abstract class Modulator
implements ValueModifier {
    private float multiplier;
    private ValueModifier multiplierModifier;

    public Modulator() {
        this.setMultiplier(1.0f);
    }

    @Override
    public float modify(float value, float referenceFrequency) {
        return value + this.getNextValue(referenceFrequency);
    }

    public float getNextValue(float referenceFrequency) {
        float multiplier = this.multiplierModifier == null ? this.multiplier : this.multiplierModifier.modify(this.multiplier, referenceFrequency);
        return this.getNextNormalizedValue(referenceFrequency) * multiplier;
    }

    protected abstract float getNextNormalizedValue(float var1);

    public float getMultiplier() {
        return this.multiplier;
    }

    public Modulator setMultiplier(float multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    public ValueModifier getMultiplierModifier() {
        return this.multiplierModifier;
    }

    public Modulator setMultiplierModifier(ValueModifier multiplierModifier) {
        this.multiplierModifier = multiplierModifier;
        return this;
    }
}

